/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.ConsistentHashingStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.HashRangeAutoSplitStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.HashRangeExclusiveStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.KeySharedMode;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.Commands;

public class NonPersistentStickyKeyDispatcherMultipleConsumers
extends NonPersistentDispatcherMultipleConsumers {
    private final StickyKeyConsumerSelector selector;
    private final KeySharedMode keySharedMode;
    private static final FastThreadLocal<Map<Consumer, List<Entry>>> localGroupedEntries = new FastThreadLocal<Map<Consumer, List<Entry>>>(){

        @Override
        protected Map<Consumer, List<Entry>> initialValue() throws Exception {
            return new HashMap<Consumer, List<Entry>>();
        }
    };

    public NonPersistentStickyKeyDispatcherMultipleConsumers(NonPersistentTopic topic, Subscription subscription, KeySharedMeta ksm) {
        super(topic, subscription);
        this.keySharedMode = ksm.getKeySharedMode();
        switch (this.keySharedMode) {
            case STICKY: {
                this.selector = new HashRangeExclusiveStickyKeyConsumerSelector();
                break;
            }
            default: {
                ServiceConfiguration conf = topic.getBrokerService().getPulsar().getConfiguration();
                this.selector = conf.isSubscriptionKeySharedUseConsistentHashing() ? new ConsistentHashingStickyKeyConsumerSelector(conf.getSubscriptionKeySharedConsistentHashingReplicaPoints()) : new HashRangeAutoSplitStickyKeyConsumerSelector();
            }
        }
    }

    @VisibleForTesting
    NonPersistentStickyKeyDispatcherMultipleConsumers(NonPersistentTopic topic, Subscription subscription, StickyKeyConsumerSelector selector) {
        super(topic, subscription);
        this.keySharedMode = selector instanceof HashRangeExclusiveStickyKeyConsumerSelector ? KeySharedMode.STICKY : (selector instanceof ConsistentHashingStickyKeyConsumerSelector || selector instanceof HashRangeAutoSplitStickyKeyConsumerSelector ? KeySharedMode.AUTO_SPLIT : null);
        this.selector = selector;
    }

    @Override
    public synchronized void addConsumer(Consumer consumer) throws BrokerServiceException {
        super.addConsumer(consumer);
        try {
            this.selector.addConsumer(consumer);
        }
        catch (BrokerServiceException e) {
            this.consumerSet.removeAll(consumer);
            this.consumerList.remove(consumer);
            throw e;
        }
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws BrokerServiceException {
        super.removeConsumer(consumer);
        this.selector.removeConsumer(consumer);
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return CommandSubscribe.SubType.Key_Shared;
    }

    @Override
    public void sendMessages(List<Entry> entries) {
        Consumer consumer;
        if (entries.isEmpty()) {
            return;
        }
        if (this.consumerSet.isEmpty()) {
            entries.forEach(Entry::release);
            return;
        }
        Map<Consumer, List<Entry>> groupedEntries = localGroupedEntries.get();
        groupedEntries.clear();
        for (Entry entry : entries) {
            consumer = this.selector.select(this.peekStickyKey(entry.getDataBuffer()));
            if (consumer != null) {
                groupedEntries.computeIfAbsent(consumer, k -> new ArrayList()).add(entry);
                continue;
            }
            entry.release();
        }
        for (Map.Entry entry : groupedEntries.entrySet()) {
            consumer = (Consumer)entry.getKey();
            List entriesForConsumer = (List)entry.getValue();
            SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
            EntryBatchSizes batchSizes = EntryBatchSizes.get(entriesForConsumer.size());
            this.filterEntriesForConsumer(entriesForConsumer, batchSizes, sendMessageInfo, null, null, false);
            if (consumer.getAvailablePermits() > 0 && consumer.isWritable()) {
                consumer.sendMessages(entriesForConsumer, batchSizes, null, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.getRedeliveryTracker());
                TOTAL_AVAILABLE_PERMITS_UPDATER.addAndGet(this, -sendMessageInfo.getTotalMessages());
                continue;
            }
            entriesForConsumer.forEach(e -> {
                int totalMsgs = Commands.getNumberOfMessagesInBatch(e.getDataBuffer(), this.subscription.toString(), -1L);
                if (totalMsgs > 0) {
                    this.msgDrop.recordEvent(totalMsgs);
                }
                e.release();
            });
        }
    }

    public KeySharedMode getKeySharedMode() {
        return this.keySharedMode;
    }
}

