/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.namespace.NamespaceBundleOwnershipListener;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.TopicPoliciesService;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.broker.systopic.NamespaceEventsSystemTopicFactory;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.pulsar.common.events.ActionType;
import org.apache.pulsar.shade.org.apache.pulsar.common.events.EventType;
import org.apache.pulsar.shade.org.apache.pulsar.common.events.PulsarEvent;
import org.apache.pulsar.shade.org.apache.pulsar.common.events.TopicPoliciesEvent;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTopicBasedTopicPoliciesService
implements TopicPoliciesService {
    private final PulsarService pulsarService;
    private volatile NamespaceEventsSystemTopicFactory namespaceEventsSystemTopicFactory;
    @VisibleForTesting
    final Map<TopicName, TopicPolicies> policiesCache = new ConcurrentHashMap<TopicName, TopicPolicies>();
    private final Map<NamespaceName, AtomicInteger> ownedBundlesCountPerNamespace = new ConcurrentHashMap<NamespaceName, AtomicInteger>();
    private final Map<NamespaceName, CompletableFuture<SystemTopicClient.Reader<PulsarEvent>>> readerCaches = new ConcurrentHashMap<NamespaceName, CompletableFuture<SystemTopicClient.Reader<PulsarEvent>>>();
    @VisibleForTesting
    final Map<NamespaceName, Boolean> policyCacheInitMap = new ConcurrentHashMap<NamespaceName, Boolean>();
    private final Map<TopicName, List<TopicPolicyListener<TopicPolicies>>> listeners = new ConcurrentHashMap<TopicName, List<TopicPolicyListener<TopicPolicies>>>();
    private static final Logger log = LoggerFactory.getLogger(SystemTopicBasedTopicPoliciesService.class);

    public SystemTopicBasedTopicPoliciesService(PulsarService pulsarService) {
        this.pulsarService = pulsarService;
    }

    @Override
    public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName topicName) {
        return this.sendTopicPolicyEvent(topicName, ActionType.DELETE, null);
    }

    @Override
    public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName topicName, TopicPolicies policies) {
        return this.sendTopicPolicyEvent(topicName, ActionType.UPDATE, policies);
    }

    private CompletableFuture<Void> sendTopicPolicyEvent(TopicName topicName, ActionType actionType, TopicPolicies policies) {
        this.createSystemTopicFactoryIfNeeded();
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        TopicPoliciesSystemTopicClient systemTopicClient = this.namespaceEventsSystemTopicFactory.createTopicPoliciesSystemTopicClient(topicName.getNamespaceObject());
        CompletableFuture writerFuture = systemTopicClient.newWriterAsync();
        writerFuture.whenComplete((writer, ex) -> {
            if (ex != null) {
                result.completeExceptionally((Throwable)ex);
            } else {
                PulsarEvent event = this.getPulsarEvent(topicName, actionType, policies);
                CompletableFuture<MessageId> actionFuture = ActionType.DELETE.equals((Object)actionType) ? writer.deleteAsync(event) : writer.writeAsync(event);
                actionFuture.whenComplete((messageId, e) -> {
                    if (e != null) {
                        result.completeExceptionally((Throwable)e);
                    } else if (messageId != null) {
                        result.complete(null);
                    } else {
                        result.completeExceptionally(new RuntimeException("Got message id is null."));
                    }
                    writer.closeAsync().whenComplete((v, cause) -> {
                        if (cause != null) {
                            log.error("[{}] Close writer error.", (Object)topicName, cause);
                        } else if (log.isDebugEnabled()) {
                            log.debug("[{}] Close writer success.", (Object)topicName);
                        }
                    });
                });
            }
        });
        return result;
    }

    private PulsarEvent getPulsarEvent(TopicName topicName, ActionType actionType, TopicPolicies policies) {
        return PulsarEvent.builder().actionType(actionType).eventType(EventType.TOPIC_POLICY).topicPoliciesEvent(TopicPoliciesEvent.builder().domain(topicName.getDomain().toString()).tenant(topicName.getTenant()).namespace(topicName.getNamespaceObject().getLocalName()).topic(TopicName.get(topicName.getPartitionedTopicName()).getLocalName()).policies(policies).build()).build();
    }

    private void notifyListener(Message<PulsarEvent> msg) {
        if (!EventType.TOPIC_POLICY.equals((Object)msg.getValue().getEventType())) {
            return;
        }
        TopicPoliciesEvent event = msg.getValue().getTopicPoliciesEvent();
        TopicName topicName = TopicName.get(event.getDomain(), event.getTenant(), event.getNamespace(), event.getTopic());
        if (this.listeners.get(topicName) != null) {
            TopicPolicies policies = event.getPolicies();
            for (TopicPolicyListener<TopicPolicies> listener : this.listeners.get(topicName)) {
                listener.onUpdate(policies);
            }
        }
    }

    @Override
    public TopicPolicies getTopicPolicies(TopicName topicName) throws BrokerServiceException.TopicPoliciesCacheNotInitException {
        if (this.policyCacheInitMap.containsKey(topicName.getNamespaceObject()) && !this.policyCacheInitMap.get(topicName.getNamespaceObject()).booleanValue()) {
            throw new BrokerServiceException.TopicPoliciesCacheNotInitException();
        }
        return this.policiesCache.get(TopicName.get(topicName.getPartitionedTopicName()));
    }

    @Override
    public CompletableFuture<TopicPolicies> getTopicPoliciesBypassCacheAsync(TopicName topicName) {
        CompletableFuture<TopicPolicies> result = new CompletableFuture<TopicPolicies>();
        this.createSystemTopicFactoryIfNeeded();
        if (this.namespaceEventsSystemTopicFactory == null) {
            result.complete(null);
            return result;
        }
        TopicPoliciesSystemTopicClient systemTopicClient = this.namespaceEventsSystemTopicFactory.createTopicPoliciesSystemTopicClient(topicName.getNamespaceObject());
        systemTopicClient.newReaderAsync().thenAccept(r -> this.fetchTopicPoliciesAsyncAndCloseReader((SystemTopicClient.Reader<PulsarEvent>)r, topicName, null, result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        NamespaceName namespace = namespaceBundle.getNamespaceObject();
        if (NamespaceService.checkHeartbeatNamespace(namespace) != null || NamespaceService.checkHeartbeatNamespaceV2(namespace) != null) {
            result.complete(null);
            return result;
        }
        this.createSystemTopicFactoryIfNeeded();
        SystemTopicBasedTopicPoliciesService systemTopicBasedTopicPoliciesService = this;
        synchronized (systemTopicBasedTopicPoliciesService) {
            if (this.readerCaches.get(namespace) != null) {
                this.ownedBundlesCountPerNamespace.get(namespace).incrementAndGet();
                result.complete(null);
            } else {
                TopicPoliciesSystemTopicClient systemTopicClient = this.namespaceEventsSystemTopicFactory.createTopicPoliciesSystemTopicClient(namespace);
                this.ownedBundlesCountPerNamespace.putIfAbsent(namespace, new AtomicInteger(1));
                this.policyCacheInitMap.put(namespace, false);
                CompletableFuture readerCompletableFuture = systemTopicClient.newReaderAsync();
                this.readerCaches.put(namespace, readerCompletableFuture);
                readerCompletableFuture.whenComplete((reader, ex) -> {
                    if (ex != null) {
                        log.error("[{}] Failed to create reader on __change_events topic", (Object)namespace, ex);
                        result.completeExceptionally((Throwable)ex);
                    } else {
                        this.initPolicesCache((SystemTopicClient.Reader<PulsarEvent>)reader, result);
                        result.thenRun(() -> this.readMorePolicies((SystemTopicClient.Reader<PulsarEvent>)reader));
                    }
                });
            }
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> removeOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
        CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> readerCompletableFuture;
        NamespaceName namespace = namespaceBundle.getNamespaceObject();
        if (NamespaceService.checkHeartbeatNamespace(namespace) != null || NamespaceService.checkHeartbeatNamespaceV2(namespace) != null) {
            return CompletableFuture.completedFuture(null);
        }
        AtomicInteger bundlesCount = this.ownedBundlesCountPerNamespace.get(namespace);
        if ((bundlesCount == null || bundlesCount.decrementAndGet() <= 0) && (readerCompletableFuture = this.readerCaches.remove(namespace)) != null) {
            readerCompletableFuture.thenAccept(SystemTopicClient.Reader::closeAsync);
            this.ownedBundlesCountPerNamespace.remove(namespace);
            this.policyCacheInitMap.remove(namespace);
            this.policiesCache.entrySet().removeIf(entry -> ((TopicName)entry.getKey()).getNamespaceObject().equals(namespace));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void start() {
        this.pulsarService.getNamespaceService().addNamespaceBundleOwnershipListener(new NamespaceBundleOwnershipListener(){

            @Override
            public void onLoad(NamespaceBundle bundle) {
                SystemTopicBasedTopicPoliciesService.this.addOwnedNamespaceBundleAsync(bundle);
            }

            @Override
            public void unLoad(NamespaceBundle bundle) {
                SystemTopicBasedTopicPoliciesService.this.removeOwnedNamespaceBundleAsync(bundle);
            }

            @Override
            public boolean test(NamespaceBundle namespaceBundle) {
                return true;
            }
        });
    }

    private void initPolicesCache(SystemTopicClient.Reader<PulsarEvent> reader, CompletableFuture<Void> future) {
        reader.hasMoreEventsAsync().whenComplete((hasMore, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to check the move events for the system topic", (Object)reader.getSystemTopic().getTopicName(), ex);
                future.completeExceptionally((Throwable)ex);
                this.readerCaches.remove(reader.getSystemTopic().getTopicName().getNamespaceObject());
            }
            if (hasMore.booleanValue()) {
                reader.readNextAsync().whenComplete((msg, e) -> {
                    if (e != null) {
                        log.error("[{}] Failed to read event from the system topic.", (Object)reader.getSystemTopic().getTopicName(), ex);
                        future.completeExceptionally((Throwable)e);
                        this.readerCaches.remove(reader.getSystemTopic().getTopicName().getNamespaceObject());
                    }
                    this.refreshTopicPoliciesCache((Message<PulsarEvent>)msg);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Loop next event reading for system topic.", (Object)reader.getSystemTopic().getTopicName().getNamespaceObject());
                    }
                    this.initPolicesCache(reader, future);
                });
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Reach the end of the system topic.", (Object)reader.getSystemTopic().getTopicName());
                }
                this.policyCacheInitMap.computeIfPresent(reader.getSystemTopic().getTopicName().getNamespaceObject(), (k, v) -> true);
                this.policiesCache.forEach((topicName, topicPolicies) -> {
                    if (this.listeners.get(topicName) != null) {
                        for (TopicPolicyListener<TopicPolicies> listener : this.listeners.get(topicName)) {
                            listener.onUpdate((TopicPolicies)topicPolicies);
                        }
                    }
                });
                future.complete(null);
            }
        });
    }

    private void readMorePolicies(SystemTopicClient.Reader<PulsarEvent> reader) {
        reader.readNextAsync().whenComplete((msg, ex) -> {
            if (ex == null) {
                this.refreshTopicPoliciesCache((Message<PulsarEvent>)msg);
                this.notifyListener((Message<PulsarEvent>)msg);
                this.readMorePolicies(reader);
            } else if (ex instanceof PulsarClientException.AlreadyClosedException) {
                log.error("Read more topic policies exception, close the read now!", ex);
                NamespaceName namespace = reader.getSystemTopic().getTopicName().getNamespaceObject();
                this.ownedBundlesCountPerNamespace.remove(namespace);
                this.readerCaches.remove(namespace);
            } else {
                this.readMorePolicies(reader);
            }
        });
    }

    private void refreshTopicPoliciesCache(Message<PulsarEvent> msg) {
        if (msg.getValue() == null) {
            this.policiesCache.remove(TopicName.get(TopicName.get(msg.getKey()).getPartitionedTopicName()));
            return;
        }
        if (EventType.TOPIC_POLICY.equals((Object)msg.getValue().getEventType())) {
            TopicPoliciesEvent event = msg.getValue().getTopicPoliciesEvent();
            TopicName topicName = TopicName.get(event.getDomain(), event.getTenant(), event.getNamespace(), event.getTopic());
            switch (msg.getValue().getActionType()) {
                case INSERT: {
                    TopicPolicies old = this.policiesCache.putIfAbsent(topicName, event.getPolicies());
                    if (old == null) break;
                    log.warn("Policy insert failed, the topic: {}' policy already exist", (Object)topicName);
                    break;
                }
                case UPDATE: {
                    this.policiesCache.put(topicName, event.getPolicies());
                    break;
                }
                case DELETE: {
                    this.policiesCache.remove(topicName);
                    TopicPoliciesSystemTopicClient systemTopicClient = this.namespaceEventsSystemTopicFactory.createTopicPoliciesSystemTopicClient(topicName.getNamespaceObject());
                    systemTopicClient.newWriterAsync().thenAccept(writer -> writer.deleteAsync(this.getPulsarEvent(topicName, ActionType.DELETE, null)).whenComplete((result, e) -> writer.closeAsync().whenComplete((res, ex) -> {
                        if (ex != null) {
                            log.error("close writer failed ", ex);
                        }
                    })));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    log.warn("Unknown event action type: {}", (Object)msg.getValue().getActionType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSystemTopicFactoryIfNeeded() {
        if (this.namespaceEventsSystemTopicFactory == null) {
            SystemTopicBasedTopicPoliciesService systemTopicBasedTopicPoliciesService = this;
            synchronized (systemTopicBasedTopicPoliciesService) {
                if (this.namespaceEventsSystemTopicFactory == null) {
                    try {
                        this.namespaceEventsSystemTopicFactory = new NamespaceEventsSystemTopicFactory(this.pulsarService.getClient());
                    }
                    catch (PulsarServerException e) {
                        log.error("Create namespace event system topic factory error.", (Throwable)e);
                    }
                }
            }
        }
    }

    private void fetchTopicPoliciesAsyncAndCloseReader(SystemTopicClient.Reader<PulsarEvent> reader, TopicName topicName, TopicPolicies policies, CompletableFuture<TopicPolicies> future) {
        reader.hasMoreEventsAsync().whenComplete((hasMore, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            }
            if (hasMore.booleanValue()) {
                reader.readNextAsync().whenComplete((msg, e) -> {
                    if (e != null) {
                        future.completeExceptionally((Throwable)e);
                    }
                    if (EventType.TOPIC_POLICY.equals((Object)((PulsarEvent)msg.getValue()).getEventType())) {
                        TopicPoliciesEvent topicPoliciesEvent = ((PulsarEvent)msg.getValue()).getTopicPoliciesEvent();
                        if (topicName.equals(TopicName.get(topicPoliciesEvent.getDomain(), topicPoliciesEvent.getTenant(), topicPoliciesEvent.getNamespace(), topicPoliciesEvent.getTopic()))) {
                            this.fetchTopicPoliciesAsyncAndCloseReader(reader, topicName, topicPoliciesEvent.getPolicies(), future);
                        } else {
                            this.fetchTopicPoliciesAsyncAndCloseReader(reader, topicName, policies, future);
                        }
                    }
                });
            } else {
                future.complete(policies);
                reader.closeAsync().whenComplete((v, e) -> {
                    if (e != null) {
                        log.error("[{}] Close reader error.", (Object)topicName, e);
                    }
                });
            }
        });
    }

    @VisibleForTesting
    long getPoliciesCacheSize() {
        return this.policiesCache.size();
    }

    @VisibleForTesting
    long getReaderCacheCount() {
        return this.readerCaches.size();
    }

    @VisibleForTesting
    boolean checkReaderIsCached(NamespaceName namespaceName) {
        return this.readerCaches.get(namespaceName) != null;
    }

    @VisibleForTesting
    Boolean getPoliciesCacheInit(NamespaceName namespaceName) {
        return this.policyCacheInitMap.get(namespaceName);
    }

    @Override
    public void registerListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        this.listeners.computeIfAbsent(topicName, k -> Lists.newCopyOnWriteArrayList()).add(listener);
    }

    @Override
    public void unregisterListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        this.listeners.computeIfAbsent(topicName, k -> Lists.newCopyOnWriteArrayList()).remove(listener);
    }

    @Override
    public void clean(TopicName topicName) {
        TopicName realTopicName = topicName;
        if (topicName.isPartitioned()) {
            realTopicName = TopicName.get(topicName.getPartitionedTopicName());
        }
        this.listeners.remove(realTopicName);
    }

    @VisibleForTesting
    protected Map<TopicName, TopicPolicies> getPoliciesCache() {
        return this.policiesCache;
    }

    @VisibleForTesting
    protected Map<TopicName, List<TopicPolicyListener<TopicPolicies>>> getListeners() {
        return this.listeners;
    }
}

