/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pulsar.shade.com.beust.jcommander.JCommander;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.beust.jcommander.Parameters;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;
import org.apache.pulsar.shade.org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.FieldContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Generate documentation automatically.")
public abstract class BaseGenerateDocumentation {
    private static final Logger log = LoggerFactory.getLogger(BaseGenerateDocumentation.class);
    JCommander jcommander;
    @Parameter(names={"-c", "--class-names"}, description="List of class names, generate documentation based on the annotations in the Class")
    private List<String> classNames = new ArrayList<String>();
    @Parameter(names={"-h", "--help"}, help=true, description="Show this help.")
    boolean help;

    public BaseGenerateDocumentation() {
        this.jcommander = new JCommander();
        this.jcommander.setProgramName("pulsar-generateDocumentation");
        this.jcommander.addObject(this);
    }

    public boolean run(String[] args) throws Exception {
        if (args.length == 0) {
            this.jcommander.usage();
            return false;
        }
        if (this.help) {
            this.jcommander.usage();
            return true;
        }
        try {
            this.jcommander.parse(Arrays.copyOfRange(args, 0, args.length));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.jcommander.usage();
            return false;
        }
        if (!CollectionUtils.isEmpty(this.classNames)) {
            for (String className : this.classNames) {
                System.out.println(this.generateDocumentByClassName(className));
            }
        }
        return true;
    }

    protected abstract String generateDocumentByClassName(String var1) throws Exception;

    protected String generateDocByFieldContext(String className, String type, StringBuilder sb) throws Exception {
        Class<?> clazz = Class.forName(className);
        Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Field[] fields = clazz.getDeclaredFields();
        sb.append("# ").append(type).append("\n");
        sb.append("|Name|Description|Default|Dynamic|Category|\n");
        sb.append("|---|---|---|---|---|\n");
        for (Field field : fields) {
            FieldContext fieldContext = field.getAnnotation(FieldContext.class);
            if (fieldContext == null) continue;
            field.setAccessible(true);
            sb.append("| ").append(field.getName()).append(" | ");
            sb.append(fieldContext.doc().replace("\n", "<br>")).append(" | ");
            sb.append(field.get(obj)).append(" | ");
            sb.append(fieldContext.dynamic()).append(" | ");
            sb.append(fieldContext.category()).append(" | ");
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String generateDocByApiModelProperty(String className, String type, StringBuilder sb) throws Exception {
        Class<?> clazz = Class.forName(className);
        Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Field[] fields = clazz.getDeclaredFields();
        sb.append("# ").append(type).append("\n");
        sb.append("|Name|Description|Default|\n");
        sb.append("|---|---|---|\n");
        for (Field field : fields) {
            ApiModelProperty fieldContext = field.getAnnotation(ApiModelProperty.class);
            if (fieldContext == null) continue;
            field.setAccessible(true);
            String name = StringUtils.isBlank(fieldContext.name()) ? field.getName() : fieldContext.name();
            sb.append("| ").append(name).append(" | ");
            sb.append(fieldContext.value().replace("\n", "<br>")).append(" | ");
            sb.append(field.get(obj)).append(" | ");
            sb.append("\n");
        }
        return sb.toString();
    }

    public JCommander getJcommander() {
        return this.jcommander;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setJcommander(JCommander jcommander) {
        this.jcommander = jcommander;
    }

    public void setClassNames(List<String> classNames) {
        this.classNames = classNames;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseGenerateDocumentation)) {
            return false;
        }
        BaseGenerateDocumentation other = (BaseGenerateDocumentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHelp() != other.isHelp()) {
            return false;
        }
        JCommander this$jcommander = this.getJcommander();
        JCommander other$jcommander = other.getJcommander();
        if (this$jcommander == null ? other$jcommander != null : !this$jcommander.equals(other$jcommander)) {
            return false;
        }
        List<String> this$classNames = this.getClassNames();
        List<String> other$classNames = other.getClassNames();
        return !(this$classNames == null ? other$classNames != null : !((Object)this$classNames).equals(other$classNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseGenerateDocumentation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHelp() ? 79 : 97);
        JCommander $jcommander = this.getJcommander();
        result = result * 59 + ($jcommander == null ? 43 : $jcommander.hashCode());
        List<String> $classNames = this.getClassNames();
        result = result * 59 + ($classNames == null ? 43 : ((Object)$classNames).hashCode());
        return result;
    }

    public String toString() {
        return "BaseGenerateDocumentation(jcommander=" + this.getJcommander() + ", classNames=" + this.getClassNames() + ", help=" + this.isHelp() + ")";
    }
}

