/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZooKeeperCache;

public class Deserializers {
    public static final ZooKeeperCache.Deserializer<String> STRING_DESERIALIZER = new StringDeserializer();
    public static final ZooKeeperCache.Deserializer<Policies> POLICY_DESERIALIZER = new PolicyDeserializer();

    public static final class PolicyDeserializer
    implements ZooKeeperCache.Deserializer<Policies> {
        @Override
        public Policies deserialize(String key, byte[] content) throws Exception {
            return ObjectMapperFactory.getThreadLocal().readValue(content, Policies.class);
        }
    }

    public static final class StringDeserializer
    implements ZooKeeperCache.Deserializer<String> {
        @Override
        public String deserialize(String key, byte[] content) throws Exception {
            return new String(content);
        }
    }
}

