/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.server;

import java.io.IOException;
import org.apache.pulsar.shade.javax.servlet.ServletContext;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap.MappedResource;
import org.apache.pulsar.shade.org.eclipse.jetty.io.ByteBufferPool;
import org.apache.pulsar.shade.org.eclipse.jetty.io.MappedByteBufferPool;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Request;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.HandlerWrapper;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class WebSocketUpgradeHandlerWrapper
extends HandlerWrapper
implements MappedWebSocketCreator {
    private NativeWebSocketConfiguration configuration;

    public WebSocketUpgradeHandlerWrapper(ServletContextHandler context) {
        this(context, new MappedByteBufferPool());
    }

    public WebSocketUpgradeHandlerWrapper(ServletContextHandler context, ByteBufferPool bufferPool) {
        this.configuration = new NativeWebSocketConfiguration(new WebSocketServerFactory((ServletContext)context.getServletContext(), bufferPool));
    }

    @Override
    public void addMapping(org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap.PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    @Deprecated
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    public void addMapping(String spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    public boolean removeMapping(String spec) {
        return this.configuration.removeMapping(spec);
    }

    @Override
    public WebSocketCreator getMapping(String target) {
        return this.configuration.getMapping(target);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.configuration.getFactory().isUpgradeRequest(request, response)) {
            MappedResource<WebSocketCreator> resource = this.configuration.getMatch(target);
            if (resource == null) {
                response.sendError(404, "No websocket endpoint matching path: " + target);
                return;
            }
            WebSocketCreator creator = resource.getResource();
            request.setAttribute(org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap.PathSpec.class.getName(), resource);
            if (this.configuration.getFactory().acceptWebSocket(creator, request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }
}

