/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.shade.org.apache.zookeeper.AsyncCallback;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.Op;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.shade.org.apache.zookeeper.common.PathUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtil.class);
    private static final Map<Integer, String> permCache = new ConcurrentHashMap<Integer, String>();

    public static boolean deleteRecursive(ZooKeeper zk, String pathRoot, int batchSize) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting tree: {}", tree);
        return ZKUtil.deleteInBatch(zk, tree, batchSize);
    }

    public static void deleteRecursive(ZooKeeper zk, String pathRoot) throws InterruptedException, KeeperException {
        ZKUtil.deleteRecursive(zk, pathRoot, 1000);
    }

    private static boolean deleteInBatch(ZooKeeper zk, List<String> tree, int batchSize) throws InterruptedException {
        int rateLimit = 10;
        ArrayList<Op> ops = new ArrayList<Op>();
        BatchedDeleteCbContext context = new BatchedDeleteCbContext(rateLimit);
        AsyncCallback.MultiCallback cb = (rc, path, ctx, opResults) -> {
            ((BatchedDeleteCbContext)ctx).sem.release();
            if (rc != KeeperException.Code.OK.intValue()) {
                ((BatchedDeleteCbContext)ctx).success.set(false);
            }
        };
        for (int i = tree.size() - 1; i >= 0; --i) {
            ops.add(Op.delete(tree.get(i), -1));
            if (ops.size() != batchSize && i != 0) continue;
            if (!context.success.get()) break;
            context.sem.acquire();
            zk.multi(ops, cb, context);
            ops = new ArrayList();
        }
        context.sem.acquire(rateLimit);
        return context.success.get();
    }

    public static void deleteRecursive(ZooKeeper zk, String pathRoot, AsyncCallback.VoidCallback cb, Object ctx) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting tree: {}", tree);
        for (int i = tree.size() - 1; i >= 0; --i) {
            zk.delete(tree.get(i), -1, cb, ctx);
        }
    }

    public static String validateFileInput(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return "File '" + file.getAbsolutePath() + "' does not exist.";
        }
        if (!file.canRead()) {
            return "Read permission is denied on the file '" + file.getAbsolutePath() + "'";
        }
        if (file.isDirectory()) {
            return "'" + file.getAbsolutePath() + "' is a direcory. it must be a file.";
        }
        return null;
    }

    public static List<String> listSubTreeBFS(ZooKeeper zk, String pathRoot) throws KeeperException, InterruptedException {
        ArrayDeque<String> queue = new ArrayDeque<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(pathRoot);
        tree.add(pathRoot);
        while (!queue.isEmpty()) {
            String node = (String)queue.poll();
            List<String> children = zk.getChildren(node, false);
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    public static void visitSubTreeDFS(ZooKeeper zk, String path, boolean watch, AsyncCallback.StringCallback cb) throws KeeperException, InterruptedException {
        PathUtils.validatePath(path);
        zk.getData(path, watch, null);
        cb.processResult(KeeperException.Code.OK.intValue(), path, null, path);
        ZKUtil.visitSubTreeDFSHelper(zk, path, watch, cb);
    }

    private static void visitSubTreeDFSHelper(ZooKeeper zk, String path, boolean watch, AsyncCallback.StringCallback cb) throws KeeperException, InterruptedException {
        boolean isRoot = path.length() == 1;
        try {
            String childPath;
            List<String> children = zk.getChildren(path, watch, null);
            Collections.sort(children);
            for (String child : children) {
                childPath = (isRoot ? path : path + "/") + child;
                cb.processResult(KeeperException.Code.OK.intValue(), childPath, null, child);
            }
            for (String child : children) {
                childPath = (isRoot ? path : path + "/") + child;
                ZKUtil.visitSubTreeDFSHelper(zk, childPath, watch, cb);
            }
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
    }

    public static String getPermString(int perms) {
        return permCache.computeIfAbsent(perms, k -> ZKUtil.constructPermString(k));
    }

    private static String constructPermString(int perms) {
        StringBuilder p = new StringBuilder();
        if ((perms & 4) != 0) {
            p.append('c');
        }
        if ((perms & 8) != 0) {
            p.append('d');
        }
        if ((perms & 1) != 0) {
            p.append('r');
        }
        if ((perms & 2) != 0) {
            p.append('w');
        }
        if ((perms & 0x10) != 0) {
            p.append('a');
        }
        return p.toString();
    }

    public static String aclToString(List<ACL> acls) {
        StringBuilder sb = new StringBuilder();
        for (ACL acl : acls) {
            sb.append(acl.getId().getScheme());
            sb.append(":");
            sb.append(acl.getId().getId());
            sb.append(":");
            sb.append(ZKUtil.getPermString(acl.getPerms()));
        }
        return sb.toString();
    }

    private static class BatchedDeleteCbContext {
        public Semaphore sem;
        public AtomicBoolean success;

        public BatchedDeleteCbContext(int rateLimit) {
            this.sem = new Semaphore(rateLimit);
            this.success = new AtomicBoolean(true);
        }
    }
}

