/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.shade.javax.servlet.ServletResponse;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.pulsar.common.intercept.InterceptException;
import org.apache.pulsar.shade.org.eclipse.jetty.http.HttpVersion;
import org.apache.pulsar.shade.org.eclipse.jetty.http.MetaData;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Response;

public class ExceptionHandler {
    public void handle(ServletResponse response, Exception ex) throws IOException {
        if (ex instanceof InterceptException) {
            String reason = ex.getMessage();
            byte[] content = reason.getBytes(StandardCharsets.UTF_8);
            MetaData.Response info = new MetaData.Response();
            info.setHttpVersion(HttpVersion.HTTP_1_1);
            info.setReason(reason);
            info.setStatus(((InterceptException)ex).getErrorCode());
            info.setContentLength(content.length);
            if (response instanceof Response) {
                ((Response)response).getHttpChannel().sendResponse(info, ByteBuffer.wrap(content), true);
            } else {
                ((HttpServletResponse)response).sendError(((InterceptException)ex).getErrorCode(), ex.getMessage());
            }
        } else {
            ((HttpServletResponse)response).sendError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ex.getMessage());
        }
    }
}

