/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack.impl;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class PendingAckHandleState {
    private static final AtomicReferenceFieldUpdater<PendingAckHandleState, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PendingAckHandleState.class, State.class, "state");
    private volatile State state = null;

    public PendingAckHandleState(State state) {
        STATE_UPDATER.set(this, state);
    }

    protected boolean changeToReadyState() {
        return STATE_UPDATER.compareAndSet(this, State.Initializing, State.Ready);
    }

    protected boolean changeToInitializingState() {
        return STATE_UPDATER.compareAndSet(this, State.None, State.Initializing);
    }

    protected boolean changeToCloseState() {
        return STATE_UPDATER.compareAndSet(this, State.Ready, State.Close) || STATE_UPDATER.compareAndSet(this, State.None, State.Close) || STATE_UPDATER.compareAndSet(this, State.Initializing, State.Close);
    }

    public boolean checkIfReady() {
        return STATE_UPDATER.get(this) == State.Ready;
    }

    public State getState() {
        return STATE_UPDATER.get(this);
    }

    public static enum State {
        None,
        Initializing,
        Ready,
        Close;

    }
}

