/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public interface SchemaCompatibilityCheck {
    public static final SchemaCompatibilityCheck DEFAULT = new SchemaCompatibilityCheck(){

        @Override
        public SchemaType getSchemaType() {
            return SchemaType.NONE;
        }

        @Override
        public void checkCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
            if (strategy == SchemaCompatibilityStrategy.ALWAYS_INCOMPATIBLE) {
                throw new IncompatibleSchemaException("Schema compatibility strategy is ALWAYS_INCOMPATIBLE");
            }
        }

        @Override
        public void checkCompatible(Iterable<SchemaData> from, SchemaData to, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
            if (strategy == SchemaCompatibilityStrategy.ALWAYS_INCOMPATIBLE) {
                throw new IncompatibleSchemaException("Schema compatibility strategy is ALWAYS_INCOMPATIBLE");
            }
        }
    };

    public SchemaType getSchemaType();

    public void checkCompatible(SchemaData var1, SchemaData var2, SchemaCompatibilityStrategy var3) throws IncompatibleSchemaException;

    public void checkCompatible(Iterable<SchemaData> var1, SchemaData var2, SchemaCompatibilityStrategy var3) throws IncompatibleSchemaException;

    default public boolean isCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) {
        try {
            this.checkCompatible(from, to, strategy);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean isCompatible(Iterable<SchemaData> from, SchemaData to, SchemaCompatibilityStrategy strategy) {
        try {
            this.checkCompatible(from, to, strategy);
            return true;
        }
        catch (IncompatibleSchemaException e) {
            return false;
        }
    }
}

