/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.service.api.FunctionsV2;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.POST;
import org.apache.pulsar.shade.javax.ws.rs.PUT;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.QueryParam;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/functions")
@Api(value="/functions", description="Functions admin apis", tags={"functions"}, hidden=true)
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class Functions
extends AdminResource {
    FunctionsV2<? extends WorkerService> functions() {
        return this.pulsar().getWorkerService().getFunctionsV2();
    }

    @POST
    @ApiOperation(value="Creates a new Pulsar Function in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request (function already exists, etc.)"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=200, message="Pulsar Function successfully created")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public Response registerFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="functionDetails") String functionDetailsJson) {
        return this.functions().registerFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionDetailsJson, this.clientAppId());
    }

    @PUT
    @ApiOperation(value="Updates a Pulsar Function currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request (function doesn't exist, etc.)"), @ApiResponse(code=200, message="Pulsar Function successfully updated")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public Response updateFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="functionDetails") String functionDetailsJson) {
        return this.functions().updateFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionDetailsJson, this.clientAppId());
    }

    @DELETE
    @ApiOperation(value="Deletes a Pulsar Function currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function doesn't exist"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=200, message="The function was successfully deleted")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public Response deregisterFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions().deregisterFunction(tenant, namespace, functionName, this.clientAppId());
    }

    @GET
    @ApiOperation(value="Fetches information about a Pulsar Function currently running in cluster mode", response=Function.FunctionMetaData.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public Response getFunctionInfo(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions().getFunctionInfo(tenant, namespace, functionName, this.clientAppId());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Function instance", response=InstanceCommunication.FunctionStatus.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this function"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/status")
    public Response getFunctionInstanceStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.functions().getFunctionInstanceStatus(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Function running in cluster mode", response=InstanceCommunication.FunctionStatus.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this function"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions")})
    @Path(value="/{tenant}/{namespace}/{functionName}/status")
    public Response getFunctionStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions().getFunctionStatusV2(tenant, namespace, functionName, this.uri.getRequestUri(), this.clientAppId());
    }

    @GET
    @ApiOperation(value="Lists all Pulsar Functions currently deployed in a given namespace", response=String.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions")})
    @Path(value="/{tenant}/{namespace}")
    public Response listFunctions(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        return this.functions().listFunctions(tenant, namespace, this.clientAppId());
    }

    @POST
    @ApiOperation(value="Triggers a Pulsar Function with a user-specified value or file data", response=Message.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/trigger")
    @Consumes(value={"multipart/form-data"})
    public Response triggerFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") String triggerValue, @FormDataParam(value="dataStream") InputStream triggerStream, @FormDataParam(value="topic") String topic) {
        return this.functions().triggerFunction(tenant, namespace, functionName, triggerValue, triggerStream, topic, this.clientAppId());
    }

    @GET
    @ApiOperation(value="Fetch the current state associated with a Pulsar Function", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The key does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/state/{key}")
    public Response getFunctionState(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="key") String key) {
        return this.functions().getFunctionState(tenant, namespace, functionName, key, this.clientAppId());
    }

    @POST
    @ApiOperation(value="Restart function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this function"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public Response restartFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) {
        return this.functions().restartFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId());
    }

    @POST
    @ApiOperation(value="Restart all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/restart")
    @Consumes(value={"application/json"})
    public Response restartFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions().restartFunctionInstances(tenant, namespace, functionName, this.clientAppId());
    }

    @POST
    @ApiOperation(value="Stop function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public Response stopFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) {
        return this.functions().stopFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId());
    }

    @POST
    @ApiOperation(value="Stop all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/stop")
    @Consumes(value={"application/json"})
    public Response stopFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions().stopFunctionInstances(tenant, namespace, functionName, this.clientAppId());
    }

    @POST
    @ApiOperation(value="Uploads Pulsar Function file data (admin only)", hidden=true)
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    public Response uploadFunction(@FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="path") String path) {
        return this.functions().uploadFunction(uploadedInputStream, path, this.clientAppId());
    }

    @GET
    @ApiOperation(value="Downloads Pulsar Function file data", hidden=true)
    @Path(value="/download")
    public Response downloadFunction(@QueryParam(value="path") String path) {
        return this.functions().downloadFunction(path, this.clientAppId());
    }

    @GET
    @ApiOperation(value="Fetches a list of supported Pulsar IO connectors currently running in cluster mode", response=List.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout")})
    @Path(value="/connectors")
    public List<ConnectorDefinition> getConnectorsList() throws IOException {
        return this.functions().getListOfConnectors();
    }
}

