/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.stats;

import java.util.Set;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.websocket.ConsumerHandler;
import org.apache.pulsar.websocket.ProducerHandler;
import org.apache.pulsar.websocket.ReaderHandler;

public class ProxyTopicStat {
    public final Set<ProducerStats> producerStats = Sets.newHashSet();
    public final Set<ConsumerStats> consumerStats = Sets.newHashSet();

    public static class ConsumerStats {
        public String remoteConnection;
        public String subscriptionName;
        public SubscriptionType subscriptionType;
        public SubscriptionMode subscriptionMode;
        public long numberOfMsgDelivered;

        public ConsumerStats() {
        }

        public ConsumerStats(ConsumerHandler handler) {
            this.subscriptionName = handler.getSubscription();
            this.subscriptionType = handler.getSubscriptionType();
            this.subscriptionMode = handler.getSubscriptionMode();
            this.remoteConnection = handler.getRemote().getInetSocketAddress().toString();
            this.numberOfMsgDelivered = handler.getMsgDeliveredCounter();
        }

        public ConsumerStats(ReaderHandler handler) {
            this.subscriptionName = handler.getSubscription();
            this.subscriptionType = handler.getSubscriptionType();
            this.remoteConnection = handler.getRemote().getInetSocketAddress().toString();
            this.numberOfMsgDelivered = handler.getMsgDeliveredCounter();
        }
    }

    public static class ProducerStats {
        public String remoteConnection;
        public long numberOfMsgPublished;

        public ProducerStats() {
        }

        public ProducerStats(ProducerHandler handler) {
            this.remoteConnection = handler.getRemote().getInetSocketAddress().toString();
            this.numberOfMsgPublished = handler.getMsgPublishedCounter();
        }
    }
}

