/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.PulsarConfiguration;

public class WebSocketProxyConfiguration
implements PulsarConfiguration {
    public static final int PROXY_SERVER_EXECUTOR_THREADS = 2 * Runtime.getRuntime().availableProcessors();
    public static final int WEBSOCKET_SERVICE_THREADS = 20;
    public static final int GLOBAL_ZK_THREADS = 8;
    @FieldContext(required=true, doc="Name of the cluster to which this broker belongs to")
    private String clusterName;
    @FieldContext(doc="The HTTPS REST service URL to connect to broker")
    private String serviceUrl;
    @FieldContext(doc="The HTTPS REST service TLS URL")
    private String serviceUrlTls;
    @FieldContext(doc="The broker binary service URL (for produce and consume operations)")
    private String brokerServiceUrl;
    @FieldContext(doc="The secured broker binary service URL (for produce and consume operations)")
    private String brokerServiceUrlTls;
    @FieldContext(doc="Path for the file used to determine the rotation status for the broker when responding to service discovery health checks")
    private String statusFilePath;
    @Deprecated
    @FieldContext(doc="Configuration Store connection string", deprecated=true)
    private String globalZookeeperServers;
    @FieldContext(doc="Connection string of configuration store servers")
    private String configurationStoreServers;
    @FieldContext(doc="ZooKeeper session timeout in milliseconds")
    private long zooKeeperSessionTimeoutMillis = 30000L;
    @FieldContext(doc="ZooKeeper cache expiry time in seconds")
    private int zooKeeperCacheExpirySeconds = 300;
    @FieldContext(doc="Port to use to server HTTP request")
    private Optional<Integer> webServicePort = Optional.of(8080);
    @FieldContext(doc="Port to use to server HTTPS request")
    private Optional<Integer> webServicePortTls = Optional.empty();
    @FieldContext(doc="Hostname or IP address the service binds on, default is 0.0.0.0.")
    private String bindAddress;
    @FieldContext(doc="Maximum size of a text message during parsing in WebSocket proxy")
    private int webSocketMaxTextFrameSize = 0x100000;
    @FieldContext(doc="Enable authentication")
    private boolean authenticationEnabled;
    @FieldContext(doc="Authentication provider name list, which is a list of class names")
    private Set<String> authenticationProviders = Sets.newTreeSet();
    @FieldContext(doc="Enforce authorization")
    private boolean authorizationEnabled;
    @FieldContext(doc="Authorization provider fully qualified class name")
    private String authorizationProvider = PulsarAuthorizationProvider.class.getName();
    @FieldContext(doc="Role names that are treated as \"super-user\", which means they can do all admin operations and publish to or consume from all topics")
    private Set<String> superUserRoles = Sets.newTreeSet();
    @FieldContext(doc="Allow wildcard matching in authorization (wildcard matching only applicable if wildcard-char: presents at first or last position. For example: *.pulsar.service,pulsar.service.*)")
    private boolean authorizationAllowWildcardsMatching = false;
    @FieldContext(doc="Proxy authentication settings used to connect to brokers")
    private String brokerClientAuthenticationPlugin;
    @FieldContext(doc="Proxy authentication parameters used to connect to brokers")
    private String brokerClientAuthenticationParameters;
    @FieldContext(doc="Path for the trusted TLS certificate file for outgoing connection to a server (broker)")
    private String brokerClientTrustCertsFilePath = "";
    @FieldContext(doc="Number of IO threads in Pulsar client used in WebSocket proxy")
    private int webSocketNumIoThreads = Runtime.getRuntime().availableProcessors();
    @FieldContext(doc="Number of threads to used in HTTP server")
    private int numHttpServerThreads = Math.max(6, Runtime.getRuntime().availableProcessors());
    @FieldContext(doc="Number of connections per broker in Pulsar client used in WebSocket proxy")
    private int webSocketConnectionsPerBroker = Runtime.getRuntime().availableProcessors();
    @FieldContext(doc="Timeout of idling WebSocket session (in millisecond)")
    private int webSocketSessionIdleTimeoutMillis = 300000;
    @FieldContext(doc="When this parameter is not empty, unauthenticated users perform as anonymousUserRole")
    private String anonymousUserRole = null;
    @Deprecated
    private boolean tlsEnabled = false;
    @FieldContext(doc="Enable TLS of broker client")
    private boolean brokerClientTlsEnabled = false;
    @FieldContext(doc="Path for the TLS certificate file")
    private String tlsCertificateFilePath;
    @FieldContext(doc="Path for the TLS private key file")
    private String tlsKeyFilePath;
    @FieldContext(doc="Path for the trusted TLS certificate file")
    private String tlsTrustCertsFilePath = "";
    @FieldContext(doc="Accept untrusted TLS certificate from client")
    private boolean tlsAllowInsecureConnection = false;
    @FieldContext(doc="Specify whether client certificates are required for TLS rejecting the connection if the client certificate is not trusted")
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    @FieldContext(doc="TLS cert refresh duration (in second). 0 means checking every new connection.")
    private long tlsCertRefreshCheckDurationSec = 300L;
    @FieldContext(doc="Key-value properties. Types are all String")
    private Properties properties = new Properties();

    public String getClusterName() {
        return this.clusterName;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public String getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public String getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public String getStatusFilePath() {
        return this.statusFilePath;
    }

    @Deprecated
    public String getGlobalZookeeperServers() {
        return this.globalZookeeperServers;
    }

    public String getConfigurationStoreServers() {
        return this.configurationStoreServers;
    }

    public long getZooKeeperSessionTimeoutMillis() {
        return this.zooKeeperSessionTimeoutMillis;
    }

    public int getZooKeeperCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds;
    }

    public Optional<Integer> getWebServicePort() {
        return this.webServicePort;
    }

    public Optional<Integer> getWebServicePortTls() {
        return this.webServicePortTls;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public int getWebSocketMaxTextFrameSize() {
        return this.webSocketMaxTextFrameSize;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public String getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    public boolean isAuthorizationAllowWildcardsMatching() {
        return this.authorizationAllowWildcardsMatching;
    }

    public String getBrokerClientAuthenticationPlugin() {
        return this.brokerClientAuthenticationPlugin;
    }

    public String getBrokerClientAuthenticationParameters() {
        return this.brokerClientAuthenticationParameters;
    }

    public String getBrokerClientTrustCertsFilePath() {
        return this.brokerClientTrustCertsFilePath;
    }

    public int getWebSocketNumIoThreads() {
        return this.webSocketNumIoThreads;
    }

    public int getNumHttpServerThreads() {
        return this.numHttpServerThreads;
    }

    public int getWebSocketConnectionsPerBroker() {
        return this.webSocketConnectionsPerBroker;
    }

    public int getWebSocketSessionIdleTimeoutMillis() {
        return this.webSocketSessionIdleTimeoutMillis;
    }

    public String getAnonymousUserRole() {
        return this.anonymousUserRole;
    }

    @Deprecated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public boolean isBrokerClientTlsEnabled() {
        return this.brokerClientTlsEnabled;
    }

    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    public long getTlsCertRefreshCheckDurationSec() {
        return this.tlsCertRefreshCheckDurationSec;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceUrlTls(String serviceUrlTls) {
        this.serviceUrlTls = serviceUrlTls;
    }

    public void setBrokerServiceUrl(String brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
    }

    public void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public void setStatusFilePath(String statusFilePath) {
        this.statusFilePath = statusFilePath;
    }

    @Deprecated
    public void setGlobalZookeeperServers(String globalZookeeperServers) {
        this.globalZookeeperServers = globalZookeeperServers;
    }

    public void setConfigurationStoreServers(String configurationStoreServers) {
        this.configurationStoreServers = configurationStoreServers;
    }

    public void setZooKeeperSessionTimeoutMillis(long zooKeeperSessionTimeoutMillis) {
        this.zooKeeperSessionTimeoutMillis = zooKeeperSessionTimeoutMillis;
    }

    public void setZooKeeperCacheExpirySeconds(int zooKeeperCacheExpirySeconds) {
        this.zooKeeperCacheExpirySeconds = zooKeeperCacheExpirySeconds;
    }

    public void setWebServicePort(Optional<Integer> webServicePort) {
        this.webServicePort = webServicePort;
    }

    public void setWebServicePortTls(Optional<Integer> webServicePortTls) {
        this.webServicePortTls = webServicePortTls;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setWebSocketMaxTextFrameSize(int webSocketMaxTextFrameSize) {
        this.webSocketMaxTextFrameSize = webSocketMaxTextFrameSize;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public void setAuthenticationProviders(Set<String> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
    }

    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
    }

    public void setAuthorizationProvider(String authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    public void setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
    }

    public void setAuthorizationAllowWildcardsMatching(boolean authorizationAllowWildcardsMatching) {
        this.authorizationAllowWildcardsMatching = authorizationAllowWildcardsMatching;
    }

    public void setBrokerClientAuthenticationPlugin(String brokerClientAuthenticationPlugin) {
        this.brokerClientAuthenticationPlugin = brokerClientAuthenticationPlugin;
    }

    public void setBrokerClientAuthenticationParameters(String brokerClientAuthenticationParameters) {
        this.brokerClientAuthenticationParameters = brokerClientAuthenticationParameters;
    }

    public void setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
    }

    public void setWebSocketNumIoThreads(int webSocketNumIoThreads) {
        this.webSocketNumIoThreads = webSocketNumIoThreads;
    }

    public void setNumHttpServerThreads(int numHttpServerThreads) {
        this.numHttpServerThreads = numHttpServerThreads;
    }

    public void setWebSocketConnectionsPerBroker(int webSocketConnectionsPerBroker) {
        this.webSocketConnectionsPerBroker = webSocketConnectionsPerBroker;
    }

    public void setWebSocketSessionIdleTimeoutMillis(int webSocketSessionIdleTimeoutMillis) {
        this.webSocketSessionIdleTimeoutMillis = webSocketSessionIdleTimeoutMillis;
    }

    public void setAnonymousUserRole(String anonymousUserRole) {
        this.anonymousUserRole = anonymousUserRole;
    }

    @Deprecated
    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public void setBrokerClientTlsEnabled(boolean brokerClientTlsEnabled) {
        this.brokerClientTlsEnabled = brokerClientTlsEnabled;
    }

    public void setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
    }

    public void setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
    }

    public void setTlsCertRefreshCheckDurationSec(long tlsCertRefreshCheckDurationSec) {
        this.tlsCertRefreshCheckDurationSec = tlsCertRefreshCheckDurationSec;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

