/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ReplicatorStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.PublisherStatsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.SubscriptionStatsImpl;

public class TopicStatsImpl
implements TopicStats {
    @JsonIgnore
    private int count;
    public double msgRateIn;
    public double msgThroughputIn;
    public double msgRateOut;
    public double msgThroughputOut;
    public long bytesInCounter;
    public long msgInCounter;
    public long bytesOutCounter;
    public long msgOutCounter;
    public double averageMsgSize;
    public boolean msgChunkPublished;
    public long storageSize;
    public long backlogSize;
    public long offloadedStorageSize;
    public List<PublisherStatsImpl> publishers = new ArrayList<PublisherStatsImpl>();
    public int waitingPublishers;
    public Map<String, SubscriptionStatsImpl> subscriptions = new HashMap<String, SubscriptionStatsImpl>();
    public Map<String, ReplicatorStatsImpl> replication = new TreeMap<String, ReplicatorStatsImpl>();
    public String deduplicationStatus;
    public Long topicEpoch;
    public int nonContiguousDeletedMessagesRanges;
    public int nonContiguousDeletedMessagesRangesSerializedSize;

    @Override
    public List<? extends PublisherStats> getPublishers() {
        return this.publishers;
    }

    @Override
    public Map<String, ? extends SubscriptionStats> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public Map<String, ? extends ReplicatorStats> getReplication() {
        return this.replication;
    }

    public void reset() {
        this.count = 0;
        this.msgRateIn = 0.0;
        this.msgThroughputIn = 0.0;
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.averageMsgSize = 0.0;
        this.storageSize = 0L;
        this.backlogSize = 0L;
        this.bytesInCounter = 0L;
        this.msgInCounter = 0L;
        this.bytesOutCounter = 0L;
        this.msgOutCounter = 0L;
        this.publishers.clear();
        this.subscriptions.clear();
        this.waitingPublishers = 0;
        this.replication.clear();
        this.deduplicationStatus = null;
        this.topicEpoch = null;
        this.nonContiguousDeletedMessagesRanges = 0;
        this.nonContiguousDeletedMessagesRangesSerializedSize = 0;
        this.offloadedStorageSize = 0L;
    }

    public TopicStatsImpl add(TopicStats ts) {
        ReplicatorStatsImpl replStats;
        SubscriptionStatsImpl subscriptionStats;
        int i;
        double newAverageMsgSize;
        TopicStatsImpl stats = (TopicStatsImpl)ts;
        ++this.count;
        this.msgRateIn += stats.msgRateIn;
        this.msgThroughputIn += stats.msgThroughputIn;
        this.msgRateOut += stats.msgRateOut;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.bytesInCounter += stats.bytesInCounter;
        this.msgInCounter += stats.msgInCounter;
        this.bytesOutCounter += stats.bytesOutCounter;
        this.msgOutCounter += stats.msgOutCounter;
        this.waitingPublishers += stats.waitingPublishers;
        this.averageMsgSize = newAverageMsgSize = (this.averageMsgSize * (double)(this.count - 1) + stats.averageMsgSize) / (double)this.count;
        this.storageSize += stats.storageSize;
        this.backlogSize += stats.backlogSize;
        this.offloadedStorageSize += stats.offloadedStorageSize;
        this.nonContiguousDeletedMessagesRanges += stats.nonContiguousDeletedMessagesRanges;
        this.nonContiguousDeletedMessagesRangesSerializedSize += stats.nonContiguousDeletedMessagesRangesSerializedSize;
        if (this.publishers.size() != stats.publishers.size()) {
            for (i = 0; i < stats.publishers.size(); ++i) {
                PublisherStatsImpl publisherStats = new PublisherStatsImpl();
                this.publishers.add(publisherStats.add(stats.publishers.get(i)));
            }
        } else {
            for (i = 0; i < stats.publishers.size(); ++i) {
                this.publishers.get(i).add(stats.publishers.get(i));
            }
        }
        if (this.subscriptions.size() != stats.subscriptions.size()) {
            for (String subscription : stats.subscriptions.keySet()) {
                subscriptionStats = new SubscriptionStatsImpl();
                this.subscriptions.put(subscription, subscriptionStats.add(stats.subscriptions.get(subscription)));
            }
        } else {
            for (String subscription : stats.subscriptions.keySet()) {
                if (this.subscriptions.get(subscription) != null) {
                    this.subscriptions.get(subscription).add(stats.subscriptions.get(subscription));
                    continue;
                }
                subscriptionStats = new SubscriptionStatsImpl();
                this.subscriptions.put(subscription, subscriptionStats.add(stats.subscriptions.get(subscription)));
            }
        }
        if (this.replication.size() != stats.replication.size()) {
            for (String repl : stats.replication.keySet()) {
                replStats = new ReplicatorStatsImpl();
                this.replication.put(repl, replStats.add(stats.replication.get(repl)));
            }
        } else {
            for (String repl : stats.replication.keySet()) {
                if (this.replication.get(repl) != null) {
                    this.replication.get(repl).add(stats.replication.get(repl));
                    continue;
                }
                replStats = new ReplicatorStatsImpl();
                this.replication.put(repl, replStats.add(stats.replication.get(repl)));
            }
        }
        return this;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    @Override
    public double getMsgThroughputIn() {
        return this.msgThroughputIn;
    }

    @Override
    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    @Override
    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    @Override
    public long getBytesInCounter() {
        return this.bytesInCounter;
    }

    @Override
    public long getMsgInCounter() {
        return this.msgInCounter;
    }

    @Override
    public long getBytesOutCounter() {
        return this.bytesOutCounter;
    }

    @Override
    public long getMsgOutCounter() {
        return this.msgOutCounter;
    }

    @Override
    public double getAverageMsgSize() {
        return this.averageMsgSize;
    }

    @Override
    public boolean isMsgChunkPublished() {
        return this.msgChunkPublished;
    }

    @Override
    public long getStorageSize() {
        return this.storageSize;
    }

    @Override
    public long getBacklogSize() {
        return this.backlogSize;
    }

    @Override
    public long getOffloadedStorageSize() {
        return this.offloadedStorageSize;
    }

    @Override
    public int getWaitingPublishers() {
        return this.waitingPublishers;
    }

    @Override
    public String getDeduplicationStatus() {
        return this.deduplicationStatus;
    }

    @Override
    public Long getTopicEpoch() {
        return this.topicEpoch;
    }

    @Override
    public int getNonContiguousDeletedMessagesRanges() {
        return this.nonContiguousDeletedMessagesRanges;
    }

    @Override
    public int getNonContiguousDeletedMessagesRangesSerializedSize() {
        return this.nonContiguousDeletedMessagesRangesSerializedSize;
    }

    @JsonIgnore
    public void setCount(int count) {
        this.count = count;
    }

    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    public void setMsgThroughputIn(double msgThroughputIn) {
        this.msgThroughputIn = msgThroughputIn;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    public void setBytesInCounter(long bytesInCounter) {
        this.bytesInCounter = bytesInCounter;
    }

    public void setMsgInCounter(long msgInCounter) {
        this.msgInCounter = msgInCounter;
    }

    public void setBytesOutCounter(long bytesOutCounter) {
        this.bytesOutCounter = bytesOutCounter;
    }

    public void setMsgOutCounter(long msgOutCounter) {
        this.msgOutCounter = msgOutCounter;
    }

    public void setAverageMsgSize(double averageMsgSize) {
        this.averageMsgSize = averageMsgSize;
    }

    public void setMsgChunkPublished(boolean msgChunkPublished) {
        this.msgChunkPublished = msgChunkPublished;
    }

    public void setStorageSize(long storageSize) {
        this.storageSize = storageSize;
    }

    public void setBacklogSize(long backlogSize) {
        this.backlogSize = backlogSize;
    }

    public void setOffloadedStorageSize(long offloadedStorageSize) {
        this.offloadedStorageSize = offloadedStorageSize;
    }

    public void setPublishers(List<PublisherStatsImpl> publishers) {
        this.publishers = publishers;
    }

    public void setWaitingPublishers(int waitingPublishers) {
        this.waitingPublishers = waitingPublishers;
    }

    public void setSubscriptions(Map<String, SubscriptionStatsImpl> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void setReplication(Map<String, ReplicatorStatsImpl> replication) {
        this.replication = replication;
    }

    public void setDeduplicationStatus(String deduplicationStatus) {
        this.deduplicationStatus = deduplicationStatus;
    }

    public void setTopicEpoch(Long topicEpoch) {
        this.topicEpoch = topicEpoch;
    }

    public void setNonContiguousDeletedMessagesRanges(int nonContiguousDeletedMessagesRanges) {
        this.nonContiguousDeletedMessagesRanges = nonContiguousDeletedMessagesRanges;
    }

    public void setNonContiguousDeletedMessagesRangesSerializedSize(int nonContiguousDeletedMessagesRangesSerializedSize) {
        this.nonContiguousDeletedMessagesRangesSerializedSize = nonContiguousDeletedMessagesRangesSerializedSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicStatsImpl)) {
            return false;
        }
        TopicStatsImpl other = (TopicStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (Double.compare(this.getMsgRateIn(), other.getMsgRateIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputIn(), other.getMsgThroughputIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (this.getBytesInCounter() != other.getBytesInCounter()) {
            return false;
        }
        if (this.getMsgInCounter() != other.getMsgInCounter()) {
            return false;
        }
        if (this.getBytesOutCounter() != other.getBytesOutCounter()) {
            return false;
        }
        if (this.getMsgOutCounter() != other.getMsgOutCounter()) {
            return false;
        }
        if (Double.compare(this.getAverageMsgSize(), other.getAverageMsgSize()) != 0) {
            return false;
        }
        if (this.isMsgChunkPublished() != other.isMsgChunkPublished()) {
            return false;
        }
        if (this.getStorageSize() != other.getStorageSize()) {
            return false;
        }
        if (this.getBacklogSize() != other.getBacklogSize()) {
            return false;
        }
        if (this.getOffloadedStorageSize() != other.getOffloadedStorageSize()) {
            return false;
        }
        if (this.getWaitingPublishers() != other.getWaitingPublishers()) {
            return false;
        }
        if (this.getNonContiguousDeletedMessagesRanges() != other.getNonContiguousDeletedMessagesRanges()) {
            return false;
        }
        if (this.getNonContiguousDeletedMessagesRangesSerializedSize() != other.getNonContiguousDeletedMessagesRangesSerializedSize()) {
            return false;
        }
        Long this$topicEpoch = this.getTopicEpoch();
        Long other$topicEpoch = other.getTopicEpoch();
        if (this$topicEpoch == null ? other$topicEpoch != null : !((Object)this$topicEpoch).equals(other$topicEpoch)) {
            return false;
        }
        List<? extends PublisherStats> this$publishers = this.getPublishers();
        List<? extends PublisherStats> other$publishers = other.getPublishers();
        if (this$publishers == null ? other$publishers != null : !((Object)this$publishers).equals(other$publishers)) {
            return false;
        }
        Map<String, ? extends SubscriptionStats> this$subscriptions = this.getSubscriptions();
        Map<String, ? extends SubscriptionStats> other$subscriptions = other.getSubscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions)) {
            return false;
        }
        Map<String, ? extends ReplicatorStats> this$replication = this.getReplication();
        Map<String, ? extends ReplicatorStats> other$replication = other.getReplication();
        if (this$replication == null ? other$replication != null : !((Object)this$replication).equals(other$replication)) {
            return false;
        }
        String this$deduplicationStatus = this.getDeduplicationStatus();
        String other$deduplicationStatus = other.getDeduplicationStatus();
        return !(this$deduplicationStatus == null ? other$deduplicationStatus != null : !this$deduplicationStatus.equals(other$deduplicationStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopicStatsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        long $msgRateIn = Double.doubleToLongBits(this.getMsgRateIn());
        result = result * 59 + (int)($msgRateIn >>> 32 ^ $msgRateIn);
        long $msgThroughputIn = Double.doubleToLongBits(this.getMsgThroughputIn());
        result = result * 59 + (int)($msgThroughputIn >>> 32 ^ $msgThroughputIn);
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $bytesInCounter = this.getBytesInCounter();
        result = result * 59 + (int)($bytesInCounter >>> 32 ^ $bytesInCounter);
        long $msgInCounter = this.getMsgInCounter();
        result = result * 59 + (int)($msgInCounter >>> 32 ^ $msgInCounter);
        long $bytesOutCounter = this.getBytesOutCounter();
        result = result * 59 + (int)($bytesOutCounter >>> 32 ^ $bytesOutCounter);
        long $msgOutCounter = this.getMsgOutCounter();
        result = result * 59 + (int)($msgOutCounter >>> 32 ^ $msgOutCounter);
        long $averageMsgSize = Double.doubleToLongBits(this.getAverageMsgSize());
        result = result * 59 + (int)($averageMsgSize >>> 32 ^ $averageMsgSize);
        result = result * 59 + (this.isMsgChunkPublished() ? 79 : 97);
        long $storageSize = this.getStorageSize();
        result = result * 59 + (int)($storageSize >>> 32 ^ $storageSize);
        long $backlogSize = this.getBacklogSize();
        result = result * 59 + (int)($backlogSize >>> 32 ^ $backlogSize);
        long $offloadedStorageSize = this.getOffloadedStorageSize();
        result = result * 59 + (int)($offloadedStorageSize >>> 32 ^ $offloadedStorageSize);
        result = result * 59 + this.getWaitingPublishers();
        result = result * 59 + this.getNonContiguousDeletedMessagesRanges();
        result = result * 59 + this.getNonContiguousDeletedMessagesRangesSerializedSize();
        Long $topicEpoch = this.getTopicEpoch();
        result = result * 59 + ($topicEpoch == null ? 43 : ((Object)$topicEpoch).hashCode());
        List<? extends PublisherStats> $publishers = this.getPublishers();
        result = result * 59 + ($publishers == null ? 43 : ((Object)$publishers).hashCode());
        Map<String, ? extends SubscriptionStats> $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        Map<String, ? extends ReplicatorStats> $replication = this.getReplication();
        result = result * 59 + ($replication == null ? 43 : ((Object)$replication).hashCode());
        String $deduplicationStatus = this.getDeduplicationStatus();
        result = result * 59 + ($deduplicationStatus == null ? 43 : $deduplicationStatus.hashCode());
        return result;
    }

    public String toString() {
        return "TopicStatsImpl(count=" + this.getCount() + ", msgRateIn=" + this.getMsgRateIn() + ", msgThroughputIn=" + this.getMsgThroughputIn() + ", msgRateOut=" + this.getMsgRateOut() + ", msgThroughputOut=" + this.getMsgThroughputOut() + ", bytesInCounter=" + this.getBytesInCounter() + ", msgInCounter=" + this.getMsgInCounter() + ", bytesOutCounter=" + this.getBytesOutCounter() + ", msgOutCounter=" + this.getMsgOutCounter() + ", averageMsgSize=" + this.getAverageMsgSize() + ", msgChunkPublished=" + this.isMsgChunkPublished() + ", storageSize=" + this.getStorageSize() + ", backlogSize=" + this.getBacklogSize() + ", offloadedStorageSize=" + this.getOffloadedStorageSize() + ", publishers=" + this.getPublishers() + ", waitingPublishers=" + this.getWaitingPublishers() + ", subscriptions=" + this.getSubscriptions() + ", replication=" + this.getReplication() + ", deduplicationStatus=" + this.getDeduplicationStatus() + ", topicEpoch=" + this.getTopicEpoch() + ", nonContiguousDeletedMessagesRanges=" + this.getNonContiguousDeletedMessagesRanges() + ", nonContiguousDeletedMessagesRangesSerializedSize=" + this.getNonContiguousDeletedMessagesRangesSerializedSize() + ")";
    }
}

