/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixingStrategy;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectByteAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectByteHashMap;

public class ObjectByteIdentityHashMap<KType>
extends ObjectByteHashMap<KType> {
    public ObjectByteIdentityHashMap() {
        this(4);
    }

    public ObjectByteIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectByteIdentityHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.randomized());
    }

    public ObjectByteIdentityHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectByteIdentityHashMap(ObjectByteAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(System.identityHashCode(key), this.keyMixer);
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectByteIdentityHashMap<KType> from(KType[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectByteIdentityHashMap<KType> map = new ObjectByteIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

