/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.nio.ByteBuffer;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Optional;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.shade.com.google.protobuf.GeneratedMessageV3;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface Schema<T>
extends Cloneable {
    public static final Schema<byte[]> BYTES = DefaultImplementation.newBytesSchema();
    public static final Schema<ByteBuffer> BYTEBUFFER = DefaultImplementation.newByteBufferSchema();
    public static final Schema<String> STRING = DefaultImplementation.newStringSchema();
    public static final Schema<Byte> INT8 = DefaultImplementation.newByteSchema();
    public static final Schema<Short> INT16 = DefaultImplementation.newShortSchema();
    public static final Schema<Integer> INT32 = DefaultImplementation.newIntSchema();
    public static final Schema<Long> INT64 = DefaultImplementation.newLongSchema();
    public static final Schema<Boolean> BOOL = DefaultImplementation.newBooleanSchema();
    public static final Schema<Float> FLOAT = DefaultImplementation.newFloatSchema();
    public static final Schema<Double> DOUBLE = DefaultImplementation.newDoubleSchema();
    public static final Schema<Date> DATE = DefaultImplementation.newDateSchema();
    public static final Schema<Time> TIME = DefaultImplementation.newTimeSchema();
    public static final Schema<Timestamp> TIMESTAMP = DefaultImplementation.newTimestampSchema();
    public static final Schema<Instant> INSTANT = DefaultImplementation.newInstantSchema();
    public static final Schema<LocalDate> LOCAL_DATE = DefaultImplementation.newLocalDateSchema();
    public static final Schema<LocalTime> LOCAL_TIME = DefaultImplementation.newLocalTimeSchema();
    public static final Schema<LocalDateTime> LOCAL_DATE_TIME = DefaultImplementation.newLocalDateTimeSchema();

    default public void validate(byte[] message) {
        this.decode(message);
    }

    public byte[] encode(T var1);

    default public boolean supportSchemaVersioning() {
        return false;
    }

    default public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
    }

    default public T decode(byte[] bytes) {
        return this.decode(bytes, null);
    }

    default public T decode(byte[] bytes, byte[] schemaVersion) {
        return this.decode(bytes);
    }

    default public T decode(ByteBuffer data, byte[] schemaVersion) {
        if (data == null) {
            return null;
        }
        return this.decode(DefaultImplementation.getBytes(data), schemaVersion);
    }

    public SchemaInfo getSchemaInfo();

    default public boolean requireFetchingSchemaInfo() {
        return false;
    }

    default public void configureSchemaInfo(String topic, String componentName, SchemaInfo schemaInfo) {
    }

    public Schema<T> clone();

    default public Optional<Object> getNativeSchema() {
        return Optional.empty();
    }

    public static <T extends GeneratedMessageV3> Schema<T> PROTOBUF(Class<T> clazz) {
        return DefaultImplementation.newProtobufSchema(SchemaDefinition.builder().withPojo(clazz).build());
    }

    public static <T extends GeneratedMessageV3> Schema<T> PROTOBUF(SchemaDefinition<T> schemaDefinition) {
        return DefaultImplementation.newProtobufSchema(schemaDefinition);
    }

    public static <T extends GeneratedMessageV3> Schema<T> PROTOBUF_NATIVE(Class<T> clazz) {
        return DefaultImplementation.newProtobufNativeSchema(SchemaDefinition.builder().withPojo(clazz).build());
    }

    public static <T extends GeneratedMessageV3> Schema<T> PROTOBUF_NATIVE(SchemaDefinition<T> schemaDefinition) {
        return DefaultImplementation.newProtobufNativeSchema(schemaDefinition);
    }

    public static <T> Schema<T> AVRO(Class<T> pojo) {
        return DefaultImplementation.newAvroSchema(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> Schema<T> AVRO(SchemaDefinition<T> schemaDefinition) {
        return DefaultImplementation.newAvroSchema(schemaDefinition);
    }

    public static <T> Schema<T> JSON(Class<T> pojo) {
        return DefaultImplementation.newJSONSchema(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> Schema<T> JSON(SchemaDefinition schemaDefinition) {
        return DefaultImplementation.newJSONSchema(schemaDefinition);
    }

    public static <K, V> Schema<KeyValue<K, V>> KeyValue(Class<K> key, Class<V> value, SchemaType type) {
        return DefaultImplementation.newKeyValueSchema(key, value, type);
    }

    public static Schema<KeyValue<byte[], byte[]>> KV_BYTES() {
        return DefaultImplementation.newKeyValueBytesSchema();
    }

    public static <K, V> Schema<KeyValue<K, V>> KeyValue(Class<K> key, Class<V> value) {
        return DefaultImplementation.newKeyValueSchema(key, value, SchemaType.JSON);
    }

    public static <K, V> Schema<KeyValue<K, V>> KeyValue(Schema<K> key, Schema<V> value) {
        return DefaultImplementation.newKeyValueSchema(key, value);
    }

    public static <K, V> Schema<KeyValue<K, V>> KeyValue(Schema<K> key, Schema<V> value, KeyValueEncodingType keyValueEncodingType) {
        return DefaultImplementation.newKeyValueSchema(key, value, keyValueEncodingType);
    }

    @Deprecated
    public static Schema<GenericRecord> AUTO() {
        return Schema.AUTO_CONSUME();
    }

    public static Schema<GenericRecord> AUTO_CONSUME() {
        return DefaultImplementation.newAutoConsumeSchema();
    }

    public static Schema<byte[]> AUTO_PRODUCE_BYTES() {
        return DefaultImplementation.newAutoProduceSchema();
    }

    public static Schema<byte[]> AUTO_PRODUCE_BYTES(Schema<?> schema) {
        return DefaultImplementation.newAutoProduceSchema(schema);
    }

    public static Schema<byte[]> NATIVE_AVRO(Object schema) {
        return DefaultImplementation.newAutoProduceValidatedAvroSchema(schema);
    }

    public static Schema<?> getSchema(SchemaInfo schemaInfo) {
        return DefaultImplementation.getSchema(schemaInfo);
    }

    public static GenericSchema<GenericRecord> generic(SchemaInfo schemaInfo) {
        return DefaultImplementation.getGenericSchema(schemaInfo);
    }
}

