/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Codec;

public class TopicResources {
    private static final String MANAGED_LEDGER_PATH = "/managed-ledgers";
    private final MetadataStore store;

    TopicResources(MetadataStore store) {
        this.store = store;
    }

    public CompletableFuture<List<String>> getExistingPartitions(TopicName topic) {
        String topicPartitionPath = "/managed-ledgers/" + topic.getNamespace() + "/" + (Object)((Object)topic.getDomain());
        return this.store.getChildren(topicPartitionPath).thenApply(topics -> topics.stream().map(s -> String.format("%s://%s/%s", topic.getDomain().value(), topic.getNamespace(), Codec.decode(s))).collect(Collectors.toList()));
    }

    public CompletableFuture<Boolean> persistentTopicExists(TopicName topic) {
        String path = "/managed-ledgers/" + topic.getPersistenceNamingEncoding();
        return this.store.exists(path);
    }

    public CompletableFuture<Void> clearNamespacePersistence(NamespaceName ns) {
        String path = "/managed-ledgers/" + ns;
        return this.store.delete(path, Optional.empty());
    }

    public CompletableFuture<Void> clearDomainPersistence(NamespaceName ns) {
        String path = "/managed-ledgers/" + ns + "/persistent";
        return this.store.delete(path, Optional.empty());
    }

    public CompletableFuture<Void> clearTennantPersistence(String tenant) {
        String path = "/managed-ledgers/" + tenant;
        return this.store.delete(path, Optional.empty());
    }
}

