/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import java.util.function.Consumer;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.resourcegroup.ResourceGroup;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupConfigListener;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupService;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.resources.TenantResources;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.path.PolicyPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGroupNamespaceConfigListener
implements Consumer<Notification> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceGroupNamespaceConfigListener.class);
    private final ResourceGroupService rgService;
    private final PulsarService pulsarService;
    private final NamespaceResources namespaceResources;
    private final TenantResources tenantResources;
    private final ResourceGroupConfigListener rgConfigListener;

    public ResourceGroupNamespaceConfigListener(ResourceGroupService rgService, PulsarService pulsarService, ResourceGroupConfigListener rgConfigListener) {
        this.rgService = rgService;
        this.pulsarService = pulsarService;
        this.namespaceResources = pulsarService.getPulsarResources().getNamespaceResources();
        this.tenantResources = pulsarService.getPulsarResources().getTenantResources();
        this.rgConfigListener = rgConfigListener;
        this.loadAllNamespaceResourceGroups();
        this.namespaceResources.getStore().registerListener(this);
    }

    private void updateNamespaceResourceGroup(String path) {
        String nsName = path.substring(PolicyPath.path("policies").length() + 1);
        this.namespaceResources.getAsync(path).whenCompleteAsync((optionalPolicies, ex) -> {
            if (ex != null) {
                LOG.error("Exception when getting namespace {}", (Object)nsName, ex);
                return;
            }
            Policies policy = (Policies)optionalPolicies.get();
            this.reconcileNamespaceResourceGroup(nsName, policy);
        });
    }

    private void loadAllNamespaceResourceGroups() {
        this.tenantResources.getChildrenAsync(PolicyPath.path("policies")).whenComplete((tenantList, ex) -> {
            if (ex != null) {
                LOG.error("Exception when fetching tenants", ex);
                return;
            }
            for (String ts : tenantList) {
                this.namespaceResources.getChildrenAsync(PolicyPath.path("policies", ts)).whenComplete((nsList, ex1) -> {
                    if (ex1 != null) {
                        LOG.error("Exception when fetching namespaces", ex1);
                    } else {
                        for (String ns : nsList) {
                            this.updateNamespaceResourceGroup(PolicyPath.path("policies", ts, ns));
                        }
                    }
                });
            }
        });
    }

    public void reloadAllNamespaceResourceGroups() {
        this.loadAllNamespaceResourceGroups();
    }

    public void reconcileNamespaceResourceGroup(String ns, Policies policy) {
        boolean delete = false;
        boolean add = false;
        ResourceGroup current = this.rgService.getNamespaceResourceGroup(ns);
        if (policy == null || policy.resource_group_name == null) {
            if (current != null) {
                delete = true;
            }
        } else {
            if (current == null) {
                add = true;
            }
            if (current != null && !policy.resource_group_name.equals(current.resourceGroupName)) {
                delete = true;
            }
        }
        try {
            if (delete) {
                LOG.info("Unregistering namespace {}, resource group {}", (Object)ns, (Object)current.resourceGroupName);
                this.rgService.unRegisterNameSpace(current.resourceGroupName, ns);
            }
            if (add) {
                LOG.info("Registering namespace {} from resource group {}", (Object)ns, (Object)policy.resource_group_name);
                this.rgService.registerNameSpace(policy.resource_group_name, ns);
            }
        }
        catch (PulsarAdminException e) {
            LOG.error("Failed to {} namespace {} with resource group {}", new Object[]{delete ? "unregister" : "register", ns, policy.resource_group_name, e});
        }
    }

    @Override
    public void accept(Notification notification) {
        String notifyPath = notification.getPath();
        if (!notifyPath.startsWith(PolicyPath.path("policies"))) {
            return;
        }
        String[] parts = notifyPath.split("/");
        if (parts.length < 4) {
            return;
        }
        LOG.info("Metadata store notification: Path {}, Type {}", (Object)notifyPath, (Object)notification.getType());
        if (parts.length == 4 && notification.getType() == NotificationType.ChildrenChanged) {
            this.reloadAllNamespaceResourceGroups();
        } else if (parts.length == 5) {
            switch (notification.getType()) {
                case Modified: {
                    this.updateNamespaceResourceGroup(notifyPath);
                    break;
                }
                case Deleted: {
                    String nsName = notifyPath.substring(PolicyPath.path("policies").length() + 1);
                    ResourceGroup rg = this.rgService.getNamespaceResourceGroup(nsName);
                    if (rg == null) break;
                    try {
                        this.rgService.unRegisterNameSpace(rg.resourceGroupName, nsName);
                    }
                    catch (PulsarAdminException e) {
                        LOG.error("Failed to unregister namespace", (Throwable)e);
                    }
                    break;
                }
            }
        }
    }
}

