/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.service.schema.SchemaStorageFormat;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.shade.com.beust.jcommander.JCommander;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.CmdGenerateDocs;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarClusterMetadataTeardown {
    public static String[] localZkNodes = new String[]{"bookies", "counters", "loadbalance", "managed-ledgers", "namespace", "schemas", "stream"};
    private static final Logger log = LoggerFactory.getLogger(PulsarClusterMetadataTeardown.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject(arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return;
            }
            if (arguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("delete-cluster-metadata", arguments);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            throw e;
        }
        MetadataStore metadataStore = MetadataStoreFactory.create(arguments.zookeeper, MetadataStoreConfig.builder().sessionTimeoutMillis(arguments.zkSessionTimeoutMillis).build());
        try {
            if (arguments.bkMetadataServiceUri != null) {
                BookKeeper bookKeeper = new BookKeeper((ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(arguments.bkMetadataServiceUri));
                try {
                    ManagedLedgerFactoryImpl managedLedgerFactory = new ManagedLedgerFactoryImpl(metadataStore, bookKeeper);
                    try {
                        PulsarClusterMetadataTeardown.deleteManagedLedgers(metadataStore, managedLedgerFactory);
                        PulsarClusterMetadataTeardown.deleteSchemaLedgers(metadataStore, bookKeeper);
                    }
                    finally {
                        if (Collections.singletonList(managedLedgerFactory).get(0) != null) {
                            managedLedgerFactory.shutdown();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bookKeeper).get(0) != null) {
                        bookKeeper.close();
                    }
                }
            }
            for (String localZkNode : localZkNodes) {
                PulsarClusterMetadataTeardown.deleteRecursively(metadataStore, "/" + localZkNode).join();
            }
            if (arguments.configurationStore != null && arguments.cluster != null) {
                MetadataStore configMetadataStore = MetadataStoreFactory.create(arguments.configurationStore, MetadataStoreConfig.builder().sessionTimeoutMillis(arguments.zkSessionTimeoutMillis).build());
                try {
                    PulsarClusterMetadataTeardown.deleteRecursively(configMetadataStore, "/admin/clusters/" + arguments.cluster).join();
                }
                finally {
                    if (Collections.singletonList(configMetadataStore).get(0) != null) {
                        configMetadataStore.close();
                    }
                }
            }
            log.info("Cluster metadata for '{}' teardown.", (Object)arguments.cluster);
        }
        finally {
            if (Collections.singletonList(metadataStore).get(0) != null) {
                metadataStore.close();
            }
        }
    }

    private static CompletableFuture<Void> deleteRecursively(MetadataStore metadataStore, String path) {
        return ((CompletableFuture)((CompletableFuture)metadataStore.getChildren(path).thenCompose(children -> FutureUtil.waitForAll(children.stream().map(child -> PulsarClusterMetadataTeardown.deleteRecursively(metadataStore, path + "/" + child)).collect(Collectors.toList())))).thenCompose(__ -> metadataStore.exists(path))).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return metadataStore.delete(path, Optional.empty());
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private static void deleteLedger(BookKeeper bookKeeper, long ledgerId) {
        try {
            bookKeeper.deleteLedger(ledgerId);
            if (log.isDebugEnabled()) {
                log.debug("Delete ledger id: {}", (Object)ledgerId);
            }
        }
        catch (InterruptedException | BKException e) {
            log.error("Failed to delete ledger {}: {}", (Object)ledgerId, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static void deleteManagedLedgers(MetadataStore metadataStore, ManagedLedgerFactory managedLedgerFactory) {
        String managedLedgersRoot = "/managed-ledgers";
        metadataStore.getChildren("/managed-ledgers").join().forEach(tenant -> {
            String tenantRoot = "/managed-ledgers/" + tenant;
            metadataStore.getChildren(tenantRoot).join().forEach(namespace -> {
                String namespaceRoot = String.join((CharSequence)"/", tenantRoot, namespace, "persistent");
                metadataStore.getChildren(namespaceRoot).join().forEach(topic -> {
                    TopicName topicName = TopicName.get(String.join((CharSequence)"/", tenant, namespace, topic));
                    try {
                        managedLedgerFactory.delete(topicName.getPersistenceNamingEncoding());
                    }
                    catch (InterruptedException | ManagedLedgerException e) {
                        log.error("Failed to delete ledgers of {}: {}", (Object)topicName, (Object)e);
                        throw new RuntimeException(e);
                    }
                });
            });
        });
    }

    private static void deleteSchemaLedgers(MetadataStore metadataStore, BookKeeper bookKeeper) {
        String schemaLedgersRoot = "/schemas";
        metadataStore.getChildren("/schemas").join().forEach(tenant -> {
            String tenantRoot = "/schemas/" + tenant;
            metadataStore.getChildren(tenantRoot).join().forEach(namespace -> {
                String namespaceRoot = tenantRoot + "/" + namespace;
                metadataStore.getChildren(namespaceRoot).join().forEach(topic -> {
                    String topicRoot = namespaceRoot + "/" + topic;
                    try {
                        SchemaStorageFormat.SchemaLocator.parseFrom(metadataStore.get(topicRoot).join().get().getValue()).getIndexList().stream().map(indexEntry -> indexEntry.getPosition().getLedgerId()).forEach(ledgerId -> PulsarClusterMetadataTeardown.deleteLedger(bookKeeper, ledgerId));
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.warn("Invalid data format from {}: {}", (Object)topicRoot, (Object)e);
                    }
                });
            });
        });
    }

    private static class Arguments {
        @Parameter(names={"-zk", "--zookeeper"}, description="Local ZooKeeper quorum connection string", required=true)
        private String zookeeper;
        @Parameter(names={"--zookeeper-session-timeout-ms"}, description="Local zookeeper session timeout ms")
        private int zkSessionTimeoutMillis = 30000;
        @Parameter(names={"-c", "-cluster", "--cluster"}, description="Cluster name")
        private String cluster;
        @Parameter(names={"-cs", "--configuration-store"}, description="Configuration Store connection string")
        private String configurationStore;
        @Parameter(names={"--bookkeeper-metadata-service-uri"}, description="Metadata service uri of BookKeeper")
        private String bkMetadataServiceUri;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;
        @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

