/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.stats;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class StatsBuckets {
    private final long[] boundaries;
    private final LongAdder sumCounter;
    private final LongAdder[] buckets;
    private final long[] values;
    private long count = 0L;
    private long sum = 0L;

    public StatsBuckets(List<Long> boundaries) {
        this(boundaries.stream().mapToLong(l -> l).toArray());
    }

    public StatsBuckets(long ... boundaries) {
        Preconditions.checkArgument(boundaries.length > 0);
        Preconditions.checkArgument(this.isSorted(boundaries), "Boundaries array must be sorted");
        this.boundaries = boundaries;
        this.sumCounter = new LongAdder();
        this.buckets = new LongAdder[boundaries.length + 1];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new LongAdder();
        }
        this.values = new long[this.buckets.length];
    }

    public void addAll(StatsBuckets other) {
        Preconditions.checkArgument(this.boundaries.length == other.boundaries.length);
        Preconditions.checkArgument(this.isSorted(other.boundaries), "Boundaries array must be sorted");
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].add(other.values[i]);
        }
        this.sumCounter.add(other.count);
    }

    public void addValue(long value) {
        int idx = Arrays.binarySearch(this.boundaries, value);
        if (idx < 0) {
            idx ^= 0xFFFFFFFF;
        }
        this.buckets[idx].increment();
        this.sumCounter.add(value);
    }

    public void refresh() {
        long count = 0L;
        this.sum = this.sumCounter.sumThenReset();
        for (int i = 0; i < this.buckets.length; ++i) {
            long value = this.buckets[i].sumThenReset();
            count += value;
            this.values[i] = value;
        }
        this.count = count;
    }

    public long[] getBuckets() {
        return (long[])this.values.clone();
    }

    public long getCount() {
        return this.count;
    }

    public long getSum() {
        return this.sum;
    }

    public double getAvg() {
        return (double)this.sum / (double)this.count;
    }

    private boolean isSorted(long[] array) {
        long previous = Long.MIN_VALUE;
        for (long value : array) {
            if (value < previous) {
                return false;
            }
            previous = value;
        }
        return true;
    }
}

