/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.bookie;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.ReadOnlyEntryLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.pulsar.shade.org.apache.zookeeper.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListActiveLedgersCommand
extends BookieCommand<ActiveLedgerFlags> {
    private static final Logger LOG = LoggerFactory.getLogger(ListActiveLedgersCommand.class);
    private static final String NAME = "active ledger";
    private static final String DESC = "Retrieve bookie active ledger info.";
    private static final long DEFAULT_TIME_OUT = 1000L;
    private static final long DEFAULT_LOG_ID = 0L;
    private static final String DEFAULT_LEDGER_ID_FORMATTER = "";
    private LedgerIdFormatter ledgerIdFormatter;

    public ListActiveLedgersCommand() {
        this(new ActiveLedgerFlags());
    }

    public ListActiveLedgersCommand(LedgerIdFormatter ledgerIdFormatter) {
        this(new ActiveLedgerFlags());
        this.ledgerIdFormatter = ledgerIdFormatter;
    }

    public ListActiveLedgersCommand(ActiveLedgerFlags ledgerFlags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(ledgerFlags).build());
    }

    @Override
    public boolean apply(ServerConfiguration bkConf, ActiveLedgerFlags cmdFlags) {
        this.initLedgerFormatter(bkConf, cmdFlags);
        try {
            this.handler(bkConf, cmdFlags);
        }
        catch (ExecutionException | MetadataException e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
        return true;
    }

    private void initLedgerFormatter(ServerConfiguration conf, ActiveLedgerFlags cmdFlags) {
        if (!cmdFlags.ledgerIdFormatter.equals(DEFAULT_LEDGER_ID_FORMATTER)) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(cmdFlags.ledgerIdFormatter, conf);
        } else if (this.ledgerIdFormatter == null) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(conf);
        }
    }

    public void handler(ServerConfiguration bkConf, ActiveLedgerFlags cmdFlags) throws ExecutionException, MetadataException {
        MetadataDrivers.runFunctionWithLedgerManagerFactory(bkConf, mFactory -> {
            try (LedgerManager ledgerManager = mFactory.newLedgerManager();){
                HashSet activeLedgersOnMetadata = new HashSet();
                BookkeeperInternalCallbacks.Processor<Long> ledgerProcessor = (ledger, cb) -> {
                    activeLedgersOnMetadata.add(ledger);
                    cb.processResult(0, null, null);
                };
                CountDownLatch done = new CountDownLatch(1);
                AtomicInteger resultCode = new AtomicInteger(0);
                AsyncCallback.VoidCallback endCallback = (rs, s, obj) -> {
                    resultCode.set(rs);
                    done.countDown();
                };
                ledgerManager.asyncProcessLedgers(ledgerProcessor, endCallback, null, 0, -1);
                if (done.await(cmdFlags.timeout, TimeUnit.MILLISECONDS)) {
                    if (resultCode.get() != 0) {
                        LOG.info("Read active ledgers id from metadata store,fail code {}", (Object)resultCode.get());
                        throw BKException.create(resultCode.get());
                    }
                    ReadOnlyEntryLogger entryLogger = new ReadOnlyEntryLogger(bkConf);
                    EntryLogMetadata entryLogMetadata = entryLogger.getEntryLogMetadata(cmdFlags.logId);
                    List<Long> ledgersOnEntryLog = entryLogMetadata.getLedgersMap().keys();
                    if (ledgersOnEntryLog.size() == 0) {
                        LOG.info("Ledgers on log file {} is empty", (Object)cmdFlags.logId);
                    }
                    ArrayList<Long> activeLedgersOnEntryLog = new ArrayList<Long>(ledgersOnEntryLog.size());
                    Iterator<Long> iterator = ledgersOnEntryLog.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.printActiveLedgerOnEntryLog(cmdFlags.logId, activeLedgersOnEntryLog);
                            return null;
                        }
                        long ledger2 = iterator.next();
                        if (!activeLedgersOnMetadata.contains(ledger2)) continue;
                        activeLedgersOnEntryLog.add(ledger2);
                    }
                }
                LOG.info("Read active ledgers id from metadata store timeout");
                return null;
            }
            catch (IOException | InterruptedException | BKException e) {
                LOG.error("Received Exception while processing ledgers", (Throwable)e);
                throw new UncheckedExecutionException(e);
            }
        });
    }

    public void printActiveLedgerOnEntryLog(long logId, List<Long> activeLedgers) {
        if (activeLedgers.size() == 0) {
            LOG.info("No active ledgers on log file " + logId);
        } else {
            LOG.info("Active ledgers on entry log " + logId + " as follow:");
        }
        Collections.sort(activeLedgers);
        for (long a : activeLedgers) {
            LOG.info(this.ledgerIdFormatter.formatLedgerId(a) + " ");
        }
    }

    public static class ActiveLedgerFlags
    extends CliFlags {
        @Parameter(names={"-l", "--logid"}, description="Entry log file id")
        private long logId = 0L;
        @Parameter(names={"-t", "--timeout"}, description="Read timeout(ms)")
        private long timeout = 1000L;
        @Parameter(names={"-f", "--ledgerIdFormatter"}, description="Ledger id formatter")
        private String ledgerIdFormatter = "";

        public ActiveLedgerFlags logId(long logId) {
            this.logId = logId;
            return this;
        }

        public ActiveLedgerFlags timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public ActiveLedgerFlags ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }
    }
}

