/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stats.codahale;

import com.codahale.metrics.Snapshot;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.OutputStream;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.codahale.FastTimer;

public class FastSnapshot
extends Snapshot {
    private static final long[] EMPTY_VALUES = new long[0];
    private final FastTimer timer;
    private final long min;
    private final long max;
    private final long sum;
    private final long cnt;
    private final long pcnt;
    private final long[] values;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="long[] values is newly created array; FastTimer does not hold on to reference")
    public FastSnapshot(FastTimer timer, long min, long max, long sum, long cnt, long[] values) {
        this.timer = timer;
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.cnt = cnt;
        this.pcnt = values != null ? this.sumOf(values) : 0L;
        this.values = values;
    }

    public double getValue(double quantile) {
        if (this.pcnt == 0L || this.values == null) {
            return 0.0;
        }
        long qcnt = 0L;
        for (int i = 0; i < this.values.length; ++i) {
            if (!((double)(qcnt += this.values[i]) / (double)this.pcnt > quantile)) continue;
            return this.timer.getBucketBound(i);
        }
        return this.timer.getBucketBound(this.values.length);
    }

    public long[] getValues() {
        return EMPTY_VALUES;
    }

    public int size() {
        return 0;
    }

    public long getMax() {
        return this.max;
    }

    public double getMean() {
        return this.cnt > 0L ? (double)this.sum / (double)this.cnt : 0.0;
    }

    public long getMin() {
        return this.min;
    }

    public double getStdDev() {
        if (this.cnt < 2L || this.values == null) {
            return 0.0;
        }
        double avg = this.getMean();
        double var = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            double val = this.timer.getBucketValue(i);
            var += (double)this.values[i] * Math.pow(val - avg, 2.0);
        }
        return Math.sqrt(var / (double)this.cnt);
    }

    public void dump(OutputStream output) {
    }

    private long sumOf(long[] a) {
        long sum = 0L;
        for (long x : a) {
            sum += x;
        }
        return sum;
    }
}

