/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.shade.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreImpl
implements MetaStore {
    private static final Logger log = LoggerFactory.getLogger(MetaStoreImpl.class);
    private static final String BASE_NODE = "/managed-ledgers";
    private static final String PREFIX = "/managed-ledgers/";
    private final MetadataStore store;
    private final OrderedExecutor executor;

    public MetaStoreImpl(MetadataStore store, OrderedExecutor executor) {
        this.store = store;
        this.executor = executor;
    }

    @Override
    public void getManagedLedgerInfo(String ledgerName, boolean createIfMissing, MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo> callback) {
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.get(path).thenAcceptAsync(optResult -> {
            if (optResult.isPresent()) {
                try {
                    MLDataFormats.ManagedLedgerInfo info = MLDataFormats.ManagedLedgerInfo.parseFrom(((GetResult)optResult.get()).getValue());
                    info = MetaStoreImpl.updateMLInfoTimestamp(info);
                    callback.operationComplete(info, ((GetResult)optResult.get()).getStat());
                }
                catch (InvalidProtocolBufferException e) {
                    callback.operationFailed(MetaStoreImpl.getException(e));
                }
            } else if (createIfMissing) {
                log.info("Creating '{}'", (Object)path);
                ((CompletableFuture)this.store.put(path, new byte[0], Optional.of(-1L)).thenAccept(stat -> {
                    MLDataFormats.ManagedLedgerInfo info = MLDataFormats.ManagedLedgerInfo.getDefaultInstance();
                    callback.operationComplete(info, (Stat)stat);
                })).exceptionally(ex -> {
                    callback.operationFailed(MetaStoreImpl.getException(ex));
                    return null;
                });
            } else {
                callback.operationFailed(new ManagedLedgerException.MetadataNotFoundException("Managed ledger not found"));
            }
        }, (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncUpdateLedgerIds(String ledgerName, MLDataFormats.ManagedLedgerInfo mlInfo, Stat stat, MetaStore.MetaStoreCallback<Void> callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Updating metadata version={} with content={}", new Object[]{ledgerName, stat, mlInfo});
        }
        byte[] serializedMlInfo = mlInfo.toByteArray();
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.put(path, serializedMlInfo, Optional.of(stat.getVersion())).thenAcceptAsync(newVersion -> callback.operationComplete((Void)null, (Stat)newVersion), (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void getCursors(String ledgerName, MetaStore.MetaStoreCallback<List<String>> callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Get cursors list", (Object)ledgerName);
        }
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.getChildren(path).thenAcceptAsync(cursors -> callback.operationComplete((List<String>)cursors, null), (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncGetCursorInfo(String ledgerName, String cursorName, MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo> callback) {
        String path = PREFIX + ledgerName + "/" + cursorName;
        if (log.isDebugEnabled()) {
            log.debug("Reading from {}", (Object)path);
        }
        ((CompletableFuture)this.store.get(path).thenAcceptAsync(optRes -> {
            if (optRes.isPresent()) {
                try {
                    MLDataFormats.ManagedCursorInfo info = MLDataFormats.ManagedCursorInfo.parseFrom(((GetResult)optRes.get()).getValue());
                    callback.operationComplete(info, ((GetResult)optRes.get()).getStat());
                }
                catch (InvalidProtocolBufferException e) {
                    callback.operationFailed(MetaStoreImpl.getException(e));
                }
            } else {
                callback.operationFailed(new ManagedLedgerException.MetadataNotFoundException("Cursor metadata not found"));
            }
        }, (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncUpdateCursorInfo(String ledgerName, String cursorName, MLDataFormats.ManagedCursorInfo info, Stat stat, MetaStore.MetaStoreCallback<Void> callback) {
        long expectedVersion;
        log.info("[{}] [{}] Updating cursor info ledgerId={} mark-delete={}:{}", new Object[]{ledgerName, cursorName, info.getCursorsLedgerId(), info.getMarkDeleteLedgerId(), info.getMarkDeleteEntryId()});
        String path = PREFIX + ledgerName + "/" + cursorName;
        byte[] content = info.toByteArray();
        if (stat != null) {
            expectedVersion = stat.getVersion();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Creating consumer {} on meta-data store with {}", new Object[]{ledgerName, cursorName, info});
            }
        } else {
            expectedVersion = -1L;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Updating consumer {} on meta-data store with {}", new Object[]{ledgerName, cursorName, info});
            }
        }
        ((CompletableFuture)this.store.put(path, content, Optional.of(expectedVersion)).thenAcceptAsync(optStat -> callback.operationComplete((Void)null, (Stat)optStat), (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncRemoveCursor(String ledgerName, String cursorName, MetaStore.MetaStoreCallback<Void> callback) {
        String path = PREFIX + ledgerName + "/" + cursorName;
        log.info("[{}] Remove consumer={}", (Object)ledgerName, (Object)cursorName);
        ((CompletableFuture)this.store.delete(path, Optional.empty()).thenAcceptAsync(v -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] cursor delete done", (Object)ledgerName, (Object)cursorName);
            }
            callback.operationComplete(null, null);
        }, (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void removeManagedLedger(String ledgerName, MetaStore.MetaStoreCallback<Void> callback) {
        log.info("[{}] Remove ManagedLedger", (Object)ledgerName);
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.delete(path, Optional.empty()).thenAcceptAsync(v -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] managed ledger delete done", (Object)ledgerName);
            }
            callback.operationComplete(null, null);
        }, (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public Iterable<String> getManagedLedgers() throws ManagedLedgerException.MetaStoreException {
        try {
            return this.store.getChildren(BASE_NODE).join();
        }
        catch (CompletionException e) {
            throw MetaStoreImpl.getException(e);
        }
    }

    private static MLDataFormats.ManagedLedgerInfo updateMLInfoTimestamp(MLDataFormats.ManagedLedgerInfo info) {
        ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo> infoList = new ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo>(info.getLedgerInfoCount());
        long currentTime = System.currentTimeMillis();
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo : info.getLedgerInfoList()) {
            if (!ledgerInfo.hasTimestamp() || ledgerInfo.getTimestamp() == 0L) {
                MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder singleInfoBuilder = ledgerInfo.toBuilder();
                singleInfoBuilder.setTimestamp(currentTime);
                infoList.add(singleInfoBuilder.build());
                continue;
            }
            infoList.add(ledgerInfo);
        }
        MLDataFormats.ManagedLedgerInfo.Builder mlInfo = MLDataFormats.ManagedLedgerInfo.newBuilder();
        mlInfo.addAllLedgerInfo(infoList);
        if (info.hasTerminatedPosition()) {
            mlInfo.setTerminatedPosition(info.getTerminatedPosition());
        }
        mlInfo.addAllProperties(info.getPropertiesList());
        return mlInfo.build();
    }

    private static ManagedLedgerException.MetaStoreException getException(Throwable t) {
        if (t.getCause() instanceof MetadataStoreException.BadVersionException) {
            return new ManagedLedgerException.BadVersionException(t.getMessage());
        }
        return new ManagedLedgerException.MetaStoreException(t);
    }
}

