/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.swagger.util;

import java.io.IOException;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonParser;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pulsar.shade.io.swagger.models.parameters.BodyParameter;
import org.apache.pulsar.shade.io.swagger.models.parameters.CookieParameter;
import org.apache.pulsar.shade.io.swagger.models.parameters.FormParameter;
import org.apache.pulsar.shade.io.swagger.models.parameters.HeaderParameter;
import org.apache.pulsar.shade.io.swagger.models.parameters.Parameter;
import org.apache.pulsar.shade.io.swagger.models.parameters.PathParameter;
import org.apache.pulsar.shade.io.swagger.models.parameters.QueryParameter;
import org.apache.pulsar.shade.io.swagger.models.parameters.RefParameter;
import org.apache.pulsar.shade.io.swagger.util.Json;

public class ParameterDeserializer
extends JsonDeserializer<Parameter> {
    @Override
    public Parameter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Parameter result = null;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode sub = node.get("$ref");
        JsonNode inNode = node.get("in");
        if (sub != null) {
            result = Json.mapper().convertValue((Object)sub, RefParameter.class);
        } else if (inNode != null) {
            String in = inNode.asText();
            if ("query".equals(in)) {
                result = Json.mapper().convertValue((Object)node, QueryParameter.class);
            } else if ("header".equals(in)) {
                result = Json.mapper().convertValue((Object)node, HeaderParameter.class);
            } else if ("path".equals(in)) {
                result = Json.mapper().convertValue((Object)node, PathParameter.class);
            } else if ("formData".equals(in)) {
                result = Json.mapper().convertValue((Object)node, FormParameter.class);
            } else if ("body".equals(in)) {
                result = Json.mapper().convertValue((Object)node, BodyParameter.class);
            } else if ("cookie".equals(in)) {
                result = Json.mapper().convertValue((Object)node, CookieParameter.class);
            }
        }
        return result;
    }
}

