/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.prometheus.client.jetty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.StatisticsHandler;

public class JettyStatisticsCollector
extends Collector {
    private final StatisticsHandler statisticsHandler;
    private static final List<String> EMPTY_LIST = new ArrayList<String>();

    public JettyStatisticsCollector(StatisticsHandler statisticsHandler) {
        this.statisticsHandler = statisticsHandler;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        return Arrays.asList(JettyStatisticsCollector.buildCounter("jetty_requests_total", "Number of requests", this.statisticsHandler.getRequests()), JettyStatisticsCollector.buildGauge("jetty_requests_active", "Number of requests currently active", this.statisticsHandler.getRequestsActive()), JettyStatisticsCollector.buildGauge("jetty_requests_active_max", "Maximum number of requests that have been active at once", this.statisticsHandler.getRequestsActiveMax()), JettyStatisticsCollector.buildGauge("jetty_request_time_max_seconds", "Maximum time spent handling requests", (double)this.statisticsHandler.getRequestTimeMax() / 1000.0), JettyStatisticsCollector.buildCounter("jetty_request_time_seconds_total", "Total time spent in all request handling", (double)this.statisticsHandler.getRequestTimeTotal() / 1000.0), JettyStatisticsCollector.buildCounter("jetty_dispatched_total", "Number of dispatches", this.statisticsHandler.getDispatched()), JettyStatisticsCollector.buildGauge("jetty_dispatched_active", "Number of dispatches currently active", this.statisticsHandler.getDispatchedActive()), JettyStatisticsCollector.buildGauge("jetty_dispatched_active_max", "Maximum number of active dispatches being handled", this.statisticsHandler.getDispatchedActiveMax()), JettyStatisticsCollector.buildGauge("jetty_dispatched_time_max", "Maximum time spent in dispatch handling", this.statisticsHandler.getDispatchedTimeMax()), JettyStatisticsCollector.buildCounter("jetty_dispatched_time_seconds_total", "Total time spent in dispatch handling", (double)this.statisticsHandler.getDispatchedTimeTotal() / 1000.0), JettyStatisticsCollector.buildCounter("jetty_async_requests_total", "Total number of async requests", this.statisticsHandler.getAsyncRequests()), JettyStatisticsCollector.buildGauge("jetty_async_requests_waiting", "Currently waiting async requests", this.statisticsHandler.getAsyncRequestsWaiting()), JettyStatisticsCollector.buildGauge("jetty_async_requests_waiting_max", "Maximum number of waiting async requests", this.statisticsHandler.getAsyncRequestsWaitingMax()), JettyStatisticsCollector.buildCounter("jetty_async_dispatches_total", "Number of requested that have been asynchronously dispatched", this.statisticsHandler.getAsyncDispatches()), JettyStatisticsCollector.buildCounter("jetty_expires_total", "Number of async requests requests that have expired", this.statisticsHandler.getExpires()), this.buildStatusCounter(), JettyStatisticsCollector.buildGauge("jetty_stats_seconds", "Time in seconds stats have been collected for", (double)this.statisticsHandler.getStatsOnMs() / 1000.0), JettyStatisticsCollector.buildCounter("jetty_responses_bytes_total", "Total number of bytes across all responses", this.statisticsHandler.getResponsesBytesTotal()));
    }

    private static Collector.MetricFamilySamples buildGauge(String name, String help, double value) {
        return new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, help, Collections.singletonList(new Collector.MetricFamilySamples.Sample(name, EMPTY_LIST, EMPTY_LIST, value)));
    }

    private static Collector.MetricFamilySamples buildCounter(String name, String help, double value) {
        return new Collector.MetricFamilySamples(name, Collector.Type.COUNTER, help, Collections.singletonList(new Collector.MetricFamilySamples.Sample(name, EMPTY_LIST, EMPTY_LIST, value)));
    }

    private Collector.MetricFamilySamples buildStatusCounter() {
        String name = "jetty_responses_total";
        return new Collector.MetricFamilySamples(name, Collector.Type.COUNTER, "Number of requests with response status", Arrays.asList(JettyStatisticsCollector.buildStatusSample(name, "1xx", this.statisticsHandler.getResponses1xx()), JettyStatisticsCollector.buildStatusSample(name, "2xx", this.statisticsHandler.getResponses2xx()), JettyStatisticsCollector.buildStatusSample(name, "3xx", this.statisticsHandler.getResponses3xx()), JettyStatisticsCollector.buildStatusSample(name, "4xx", this.statisticsHandler.getResponses4xx()), JettyStatisticsCollector.buildStatusSample(name, "5xx", this.statisticsHandler.getResponses5xx())));
    }

    private static Collector.MetricFamilySamples.Sample buildStatusSample(String name, String status, double value) {
        return new Collector.MetricFamilySamples.Sample(name, Collections.singletonList("code"), Collections.singletonList(status), value);
    }
}

