/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.stats;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.pulsar.shade.io.prometheus.client.Collector;

public class PrometheusTextFormat {
    public static void write004(Writer writer, Enumeration<Collector.MetricFamilySamples> mfs) throws IOException {
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = mfs.nextElement();
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                writer.write(sample.name);
                if (sample.labelNames.size() > 0) {
                    writer.write(123);
                    for (int i = 0; i < sample.labelNames.size(); ++i) {
                        writer.write(sample.labelNames.get(i));
                        writer.write("=\"");
                        PrometheusTextFormat.writeEscapedLabelValue(writer, sample.labelValues.get(i));
                        writer.write("\",");
                    }
                    writer.write(125);
                }
                writer.write(32);
                writer.write(Collector.doubleToGoString(sample.value));
                if (sample.timestampMs != null) {
                    writer.write(32);
                    writer.write(sample.timestampMs.toString());
                }
                writer.write(10);
            }
        }
    }

    private static void writeEscapedLabelValue(Writer writer, String s) throws IOException {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    writer.append("\\\"");
                    continue block5;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block5;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }
}

