/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.config.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.config.validation.ConfigValidationAnnotations;
import org.apache.pulsar.config.validation.Validator;

public class ConfigValidation {
    private static final Class DEFAULT_ANNOTATION_CLASS = ConfigValidationAnnotations.class;

    public static void validateConfig(Object config, Class annotationClass) {
        for (Field field : config.getClass().getDeclaredFields()) {
            Object value = null;
            field.setAccessible(true);
            try {
                value = field.get(config);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            ConfigValidation.validateField(field, value, annotationClass);
        }
        ConfigValidation.validateClass(config, annotationClass);
    }

    public static void validateConfig(Object config) {
        ConfigValidation.validateConfig(config, DEFAULT_ANNOTATION_CLASS);
    }

    private static void validateClass(Object config, Class annotationClass) {
        ConfigValidation.processAnnotations(config.getClass().getAnnotations(), config.getClass().getName(), config, annotationClass);
    }

    private static void validateField(Field field, Object value, Class annotationClass) {
        ConfigValidation.processAnnotations(field.getAnnotations(), field.getName(), value, annotationClass);
    }

    private static void processAnnotations(Annotation[] annotations, String fieldName, Object value, Class annotationClass) {
        try {
            for (Annotation annotation : annotations) {
                Class<?>[] classes;
                String type = annotation.annotationType().getName();
                Class<?> validatorClass = null;
                for (Class<?> clazz : classes = annotationClass.getDeclaredClasses()) {
                    if (!clazz.getName().equals(type)) continue;
                    validatorClass = clazz;
                    break;
                }
                if (validatorClass == null) continue;
                Object v = validatorClass.cast(annotation);
                Class clazz = (Class)validatorClass.getMethod("validatorClass", new Class[0]).invoke(v, new Object[0]);
                Validator o = null;
                Map<String, Object> params = ConfigValidation.getParamsFromAnnotation(validatorClass, v);
                o = ConfigValidation.hasConstructor(clazz, Map.class) ? (Validator)clazz.getConstructor(Map.class).newInstance(params) : (Validator)clazz.newInstance();
                o.validateField(fieldName, value);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> getParamsFromAnnotation(Class<?> validatorClass, Object v) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Method method : validatorClass.getDeclaredMethods()) {
            Object value = null;
            try {
                value = method.invoke(v, new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                value = null;
            }
            if (value == null) continue;
            params.put(method.getName(), value);
        }
        return params;
    }

    public static boolean hasConstructor(Class<?> clazz, Class<?> paramClass) {
        Class[] classes = new Class[]{paramClass};
        try {
            clazz.getConstructor(classes);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

