/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.service.PublishRateLimiter;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.RateLimitFunction;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.RateLimiter;

public class PrecisPublishLimiter
implements PublishRateLimiter {
    protected volatile int publishMaxMessageRate = 0;
    protected volatile long publishMaxByteRate = 0L;
    protected volatile boolean publishThrottlingEnabled = false;
    private RateLimiter topicPublishRateLimiterOnMessage;
    private RateLimiter topicPublishRateLimiterOnByte;
    private final RateLimitFunction rateLimitFunction;

    public PrecisPublishLimiter(Policies policies, String clusterName, RateLimitFunction rateLimitFunction) {
        this.rateLimitFunction = rateLimitFunction;
        this.update(policies, clusterName);
    }

    public PrecisPublishLimiter(PublishRate publishRate, RateLimitFunction rateLimitFunction) {
        this.rateLimitFunction = rateLimitFunction;
        this.update(publishRate);
    }

    @Override
    public void checkPublishRate() {
    }

    @Override
    public void incrementPublishCount(int numOfMessages, long msgSizeInBytes) {
    }

    @Override
    public boolean resetPublishCount() {
        return true;
    }

    @Override
    public boolean isPublishRateExceeded() {
        return false;
    }

    @Override
    public void update(Policies policies, String clusterName) {
        PublishRate maxPublishRate = policies.publishMaxMessageRate != null ? policies.publishMaxMessageRate.get(clusterName) : null;
        this.update(maxPublishRate);
    }

    @Override
    public void update(PublishRate maxPublishRate) {
        if (maxPublishRate != null && (maxPublishRate.publishThrottlingRateInMsg > 0 || maxPublishRate.publishThrottlingRateInByte > 0L)) {
            this.publishThrottlingEnabled = true;
            this.publishMaxMessageRate = Math.max(maxPublishRate.publishThrottlingRateInMsg, 0);
            this.publishMaxByteRate = Math.max(maxPublishRate.publishThrottlingRateInByte, 0L);
            if (this.publishMaxMessageRate > 0) {
                this.topicPublishRateLimiterOnMessage = new RateLimiter(this.publishMaxMessageRate, 1L, TimeUnit.SECONDS, this.rateLimitFunction);
            }
            if (this.publishMaxByteRate > 0L) {
                this.topicPublishRateLimiterOnByte = new RateLimiter(this.publishMaxByteRate, 1L, TimeUnit.SECONDS);
            }
        } else {
            this.publishMaxMessageRate = 0;
            this.publishMaxByteRate = 0L;
            this.publishThrottlingEnabled = false;
            this.topicPublishRateLimiterOnMessage = null;
            this.topicPublishRateLimiterOnByte = null;
        }
    }

    @Override
    public boolean tryAcquire(int numbers, long bytes) {
        return !(this.topicPublishRateLimiterOnMessage != null && !this.topicPublishRateLimiterOnMessage.tryAcquire(numbers) || this.topicPublishRateLimiterOnByte != null && !this.topicPublishRateLimiterOnByte.tryAcquire(bytes));
    }
}

