/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.POST;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.QueryParam;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookiesClusterInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.RawBookieInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/bookies")
@Api(value="/bookies", description="Configure bookies rack placement", tags={"bookies"})
@Produces(value={"application/json"})
public class Bookies
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(Bookies.class);

    @GET
    @Path(value="/racks-info")
    @ApiOperation(value="Gets the rack placement information for all the bookies in the cluster", response=BookiesRackConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public BookiesRackConfiguration getBookiesRackInfo() throws Exception {
        this.validateSuperUserAccess();
        return this.localZkCache().getData("/bookies", (key, content) -> ObjectMapperFactory.getThreadLocal().readValue(content, BookiesRackConfiguration.class)).orElse(new BookiesRackConfiguration());
    }

    @GET
    @Path(value="/all")
    @ApiOperation(value="Gets raw information for all the bookies in the cluster", response=BookiesClusterInfo.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public BookiesClusterInfo getAllBookies() throws Exception {
        this.validateSuperUserAccess();
        BookKeeper bookKeeper = this.bookKeeper();
        MetadataClientDriver metadataClientDriver = bookKeeper.getMetadataClientDriver();
        RegistrationClient registrationClient = metadataClientDriver.getRegistrationClient();
        Set<BookieId> allBookies = registrationClient.getAllBookies().get().getValue();
        ArrayList<RawBookieInfo> result = new ArrayList<RawBookieInfo>(allBookies.size());
        for (BookieId bookieId : allBookies) {
            RawBookieInfo bookieInfo = new RawBookieInfo(bookieId.toString());
            result.add(bookieInfo);
        }
        return BookiesClusterInfo.builder().bookies(result).build();
    }

    @GET
    @Path(value="/racks-info/{bookie}")
    @ApiOperation(value="Gets the rack placement information for a specific bookie in the cluster", response=BookieInfo.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public BookieInfo getBookieRackInfo(@PathParam(value="bookie") String bookieAddress) throws Exception {
        this.validateSuperUserAccess();
        BookiesRackConfiguration racks = this.localZkCache().getData("/bookies", (key, content) -> ObjectMapperFactory.getThreadLocal().readValue(content, BookiesRackConfiguration.class)).orElse(new BookiesRackConfiguration());
        return racks.getBookie(bookieAddress).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Bookie address not found: " + bookieAddress));
    }

    @DELETE
    @Path(value="/racks-info/{bookie}")
    @ApiOperation(value="Removed the rack placement information for a specific bookie in the cluster")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void deleteBookieRackInfo(@PathParam(value="bookie") String bookieAddress) throws Exception {
        BookiesRackConfiguration racks;
        this.validateSuperUserAccess();
        Optional<Map.Entry<BookiesRackConfiguration, Stat>> entry = this.localZkCache().getEntry("/bookies", (key, content) -> ObjectMapperFactory.getThreadLocal().readValue(content, BookiesRackConfiguration.class));
        if (entry.isPresent()) {
            racks = entry.get().getKey();
            if (!racks.removeBookie(bookieAddress)) {
                throw new RestException(Response.Status.NOT_FOUND, "Bookie address not found: " + bookieAddress);
            }
        } else {
            throw new RestException(Response.Status.NOT_FOUND, "Bookie rack placement info is not found");
        }
        this.localZk().setData("/bookies", Bookies.jsonMapper().writeValueAsBytes(racks), entry.get().getValue().getVersion());
        log.info("Removed {} from rack mapping info", (Object)bookieAddress);
    }

    @POST
    @Path(value="/racks-info/{bookie}")
    @ApiOperation(value="Updates the rack placement information for a specific bookie in the cluster (note. bookie address format:`address:port`)")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void updateBookieRackInfo(@PathParam(value="bookie") String bookieAddress, @QueryParam(value="group") String group, BookieInfo bookieInfo) throws Exception {
        this.validateSuperUserAccess();
        if (group == null) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Bookie 'group' parameters is missing");
        }
        Optional<Map.Entry<BookiesRackConfiguration, Stat>> entry = this.localZkCache().getEntry("/bookies", (key, content) -> ObjectMapperFactory.getThreadLocal().readValue(content, BookiesRackConfiguration.class));
        if (entry.isPresent()) {
            BookiesRackConfiguration racks = entry.get().getKey();
            racks.updateBookie(group, bookieAddress, bookieInfo);
            this.localZk().setData("/bookies", Bookies.jsonMapper().writeValueAsBytes(racks), entry.get().getValue().getVersion());
            this.localZkCache().invalidate("/bookies");
            log.info("Updated rack mapping info for {}", (Object)bookieAddress);
        } else {
            BookiesRackConfiguration racks = new BookiesRackConfiguration();
            racks.updateBookie(group, bookieAddress, bookieInfo);
            this.localZKCreate("/bookies", Bookies.jsonMapper().writeValueAsBytes(racks));
            log.info("Created rack mapping info and added {}", (Object)bookieAddress);
        }
    }
}

