/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.spnego;

import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.pulsar.shade.org.asynchttpclient.spnego.NamePasswordCallbackHandler;
import org.apache.pulsar.shade.org.asynchttpclient.spnego.SpnegoEngineException;
import org.apache.pulsar.shade.org.asynchttpclient.spnego.SpnegoTokenGenerator;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpnegoEngine {
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private static Map<String, SpnegoEngine> instances = new HashMap<String, SpnegoEngine>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SpnegoTokenGenerator spnegoGenerator;
    private final String username;
    private final String password;
    private final String servicePrincipalName;
    private final String realmName;
    private final boolean useCanonicalHostname;
    private final String loginContextName;
    private final Map<String, String> customLoginConfig;

    public SpnegoEngine(String username, String password, String servicePrincipalName, String realmName, boolean useCanonicalHostname, Map<String, String> customLoginConfig, String loginContextName, SpnegoTokenGenerator spnegoGenerator) {
        this.username = username;
        this.password = password;
        this.servicePrincipalName = servicePrincipalName;
        this.realmName = realmName;
        this.useCanonicalHostname = useCanonicalHostname;
        this.customLoginConfig = customLoginConfig;
        this.spnegoGenerator = spnegoGenerator;
        this.loginContextName = loginContextName;
    }

    public SpnegoEngine() {
        this(null, null, null, null, true, null, null, null);
    }

    public static SpnegoEngine instance(String username, String password, String servicePrincipalName, String realmName, boolean useCanonicalHostname, Map<String, String> customLoginConfig, String loginContextName) {
        String key = "";
        if (customLoginConfig != null && !customLoginConfig.isEmpty()) {
            StringBuilder customLoginConfigKeyValues = new StringBuilder();
            for (String loginConfigKey : customLoginConfig.keySet()) {
                customLoginConfigKeyValues.append(loginConfigKey).append("=").append(customLoginConfig.get(loginConfigKey));
            }
            key = customLoginConfigKeyValues.toString();
        }
        if (username != null) {
            key = key + username;
        }
        if (loginContextName != null) {
            key = key + loginContextName;
        }
        if (!instances.containsKey(key)) {
            instances.put(key, new SpnegoEngine(username, password, servicePrincipalName, realmName, useCanonicalHostname, customLoginConfig, loginContextName, null));
        }
        return instances.get(key);
    }

    public String generateToken(String host) throws SpnegoEngineException {
        GSSContext gssContext = null;
        byte[] token = null;
        try {
            GSSName serverName;
            GSSManager manager;
            Oid negotiationOid = new Oid(SPNEGO_OID);
            boolean tryKerberos = false;
            String spn = this.getCompleteServicePrincipalName(host);
            try {
                manager = GSSManager.getInstance();
                serverName = manager.createName(spn, GSSName.NT_HOSTBASED_SERVICE);
                GSSCredential myCred = null;
                if (this.username != null || this.loginContextName != null || this.customLoginConfig != null && !this.customLoginConfig.isEmpty()) {
                    String contextName = this.loginContextName;
                    if (contextName == null) {
                        contextName = "";
                    }
                    LoginContext loginContext = new LoginContext(contextName, null, this.getUsernamePasswordHandler(), this.getLoginConfiguration());
                    loginContext.login();
                    Oid negotiationOidFinal = negotiationOid;
                    PrivilegedExceptionAction<GSSCredential> action = () -> manager.createCredential(null, Integer.MAX_VALUE, negotiationOidFinal, 0);
                    myCred = Subject.doAs(loginContext.getSubject(), action);
                }
                gssContext = manager.createContext(this.useCanonicalHostname ? serverName.canonicalize(negotiationOid) : serverName, negotiationOid, myCred, 0);
                gssContext.requestMutualAuth(true);
                gssContext.requestCredDeleg(true);
            }
            catch (GSSException ex) {
                this.log.error("generateToken", (Throwable)ex);
                if (ex.getMajor() == 2) {
                    this.log.debug("GSSException BAD_MECH, retry with Kerberos MECH");
                    tryKerberos = true;
                }
                throw ex;
            }
            if (tryKerberos) {
                this.log.debug("Using Kerberos MECH {}", (Object)KERBEROS_OID);
                negotiationOid = new Oid(KERBEROS_OID);
                manager = GSSManager.getInstance();
                serverName = manager.createName(spn, GSSName.NT_HOSTBASED_SERVICE);
                gssContext = manager.createContext(serverName.canonicalize(negotiationOid), negotiationOid, null, 0);
                gssContext.requestMutualAuth(true);
                gssContext.requestCredDeleg(true);
            }
            if (token == null) {
                token = new byte[]{};
            }
            if ((token = gssContext.initSecContext(token, 0, token.length)) == null) {
                throw new SpnegoEngineException("GSS security context initialization failed");
            }
            if (this.spnegoGenerator != null && negotiationOid.toString().equals(KERBEROS_OID)) {
                token = this.spnegoGenerator.generateSpnegoDERObject(token);
            }
            gssContext.dispose();
            String tokenstr = Base64.getEncoder().encodeToString(token);
            this.log.debug("Sending response '{}' back to the server", (Object)tokenstr);
            return tokenstr;
        }
        catch (GSSException gsse) {
            this.log.error("generateToken", (Throwable)gsse);
            if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                throw new SpnegoEngineException(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 13) {
                throw new SpnegoEngineException(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                throw new SpnegoEngineException(gsse.getMessage(), gsse);
            }
            throw new SpnegoEngineException(gsse.getMessage());
        }
        catch (IOException | PrivilegedActionException | LoginException ex) {
            throw new SpnegoEngineException(ex.getMessage());
        }
    }

    String getCompleteServicePrincipalName(String host) {
        String name;
        if (this.servicePrincipalName == null) {
            if (this.useCanonicalHostname) {
                host = this.getCanonicalHostname(host);
            }
            name = "HTTP@" + host;
        } else {
            name = this.servicePrincipalName;
            if (this.realmName != null && !name.contains("@")) {
                name = name + "@" + this.realmName;
            }
        }
        this.log.debug("Service Principal Name is {}", (Object)name);
        return name;
    }

    private String getCanonicalHostname(String hostname) {
        String canonicalHostname = hostname;
        try {
            InetAddress in = InetAddress.getByName(hostname);
            canonicalHostname = in.getCanonicalHostName();
            this.log.debug("Resolved hostname={} to canonicalHostname={}", (Object)hostname, (Object)canonicalHostname);
        }
        catch (Exception e) {
            this.log.warn("Unable to resolve canonical hostname", (Throwable)e);
        }
        return canonicalHostname;
    }

    private CallbackHandler getUsernamePasswordHandler() {
        if (this.username == null) {
            return null;
        }
        return new NamePasswordCallbackHandler(this.username, this.password);
    }

    public Configuration getLoginConfiguration() {
        if (this.customLoginConfig != null && !this.customLoginConfig.isEmpty()) {
            return new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    return new AppConfigurationEntry[]{new AppConfigurationEntry("org.apache.pulsar.shade.com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, SpnegoEngine.this.customLoginConfig)};
                }
            };
        }
        return null;
    }
}

