/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stream.server.service;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.google.common.base.Stopwatch;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.server.conf.BookieConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieWatchService
extends AbstractLifecycleComponent<BookieConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(BookieWatchService.class);
    private final int minNumBookies;

    public BookieWatchService(int minNumBookies, BookieConfiguration conf, StatsLogger statsLogger) {
        super("bookie-watcher", conf, statsLogger);
        this.minNumBookies = minNumBookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.loadConf(((BookieConfiguration)this.conf).getUnderlyingConf());
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        try {
            try {
                MetadataDrivers.runFunctionWithMetadataClientDriver(clientConf, clientDriver -> {
                    try {
                        BookieWatchService.waitingForNumBookies(clientDriver.getRegistrationClient(), this.minNumBookies);
                    }
                    catch (Exception e) {
                        log.error("Encountered exceptions on waiting {} bookies to be alive", (Object)this.minNumBookies);
                        throw new RuntimeException("Encountered exceptions on waiting " + this.minNumBookies + " bookies to be alive", e);
                    }
                    return null;
                }, executorService);
            }
            catch (ExecutionException | MetadataException e) {
                throw new RuntimeException("Failed to start bookie watch service", e);
            }
        }
        finally {
            if (Collections.singletonList(executorService).get(0) != null) {
                executorService.shutdown();
            }
        }
    }

    private static void waitingForNumBookies(RegistrationClient client, int minNumBookies) throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set<BookieId> bookies = FutureUtils.result(client.getWritableBookies()).getValue();
        while (bookies.size() < minNumBookies) {
            TimeUnit.SECONDS.sleep(1L);
            bookies = FutureUtils.result(client.getWritableBookies()).getValue();
            log.info("Only {} bookies are live since {} seconds elapsed, wait for another {} bookies for another 1 second", new Object[]{bookies.size(), stopwatch.elapsed(TimeUnit.SECONDS), minNumBookies - bookies.size()});
        }
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
    }
}

