/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.proto.checksum;

import com.scurrilous.circe.checksum.Crc32cIntChecksum;
import com.scurrilous.circe.crc.Sse42Crc32C;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.pulsar.shade.org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRC32CDigestManager
extends DigestManager {
    private static final Logger log = LoggerFactory.getLogger(CRC32CDigestManager.class);
    private static boolean nonSupportedMessagePrinted = false;
    private static final FastThreadLocal<MutableInt> currentCrc = new FastThreadLocal<MutableInt>(){

        @Override
        protected MutableInt initialValue() throws Exception {
            return new MutableInt(0);
        }
    };

    public CRC32CDigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        super(ledgerId, useV2Protocol, allocator);
        if (!Sse42Crc32C.isSupported() && !nonSupportedMessagePrinted) {
            log.warn("Sse42Crc32C is not supported, will use a slower CRC32C implementation.");
            nonSupportedMessagePrinted = true;
        }
    }

    @Override
    int getMacCodeLength() {
        return 4;
    }

    @Override
    void populateValueAndReset(ByteBuf buf) {
        MutableInt current = currentCrc.get();
        buf.writeInt(current.intValue());
        current.setValue(0);
    }

    @Override
    void update(ByteBuf data) {
        MutableInt current = currentCrc.get();
        int lastCrc = current.intValue();
        current.setValue(Crc32cIntChecksum.resumeChecksum(lastCrc, data));
    }
}

