/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.crypto;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.EncryptionKeyInfo;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.EncryptionKeys;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.MessageMetadata;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCryptoBc
implements MessageCrypto<MessageMetadata, MessageMetadata> {
    private static final Logger log = LoggerFactory.getLogger(MessageCryptoBc.class);
    private static final String ECDSA = "ECDSA";
    private static final String RSA = "RSA";
    private static final String ECIES = "ECIES";
    private static final String RSA_TRANS = "RSA/NONE/OAEPWithSHA1AndMGF1Padding";
    private static final String AESGCM = "AES/GCM/NoPadding";
    private static KeyGenerator keyGenerator;
    private static final int tagLen = 128;
    private byte[] iv = new byte[12];
    private Cipher cipher;
    MessageDigest digest;
    private String logCtx;
    private SecretKey dataKey;
    private LoadingCache<ByteBuffer, SecretKey> dataKeyCache;
    private ConcurrentHashMap<String, EncryptionKeyInfo> encryptedDataKeyMap;
    static final SecureRandom secureRandom;

    public MessageCryptoBc(String logCtx, boolean keyGenNeeded) {
        this.logCtx = logCtx;
        this.encryptedDataKeyMap = new ConcurrentHashMap();
        this.dataKeyCache = CacheBuilder.newBuilder().expireAfterAccess(4L, TimeUnit.HOURS).build(new CacheLoader<ByteBuffer, SecretKey>(){

            @Override
            public SecretKey load(ByteBuffer key) {
                return null;
            }
        });
        try {
            this.cipher = Cipher.getInstance(AESGCM, "BC");
            if (!keyGenNeeded) {
                this.digest = MessageDigest.getInstance("MD5");
                this.dataKey = null;
                return;
            }
            keyGenerator = KeyGenerator.getInstance("AES");
            int aesKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (aesKeyLength <= 128) {
                log.warn("{} AES Cryptographic strength is limited to {} bits. Consider installing JCE Unlimited Strength Jurisdiction Policy Files.", (Object)logCtx, (Object)aesKeyLength);
                keyGenerator.init(aesKeyLength, secureRandom);
            } else {
                keyGenerator.init(256, secureRandom);
            }
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            this.cipher = null;
            log.error("{} MessageCrypto initialization Failed {}", (Object)logCtx, (Object)e.getMessage());
        }
        this.dataKey = keyGenerator.generateKey();
        this.iv = new byte[12];
    }

    private PublicKey loadPublicKey(byte[] keyBytes) throws Exception {
        StringReader keyReader = new StringReader(new String(keyBytes));
        PublicKey publicKey = null;
        try (PEMParser pemReader = new PEMParser((Reader)keyReader);){
            Object pemObj = pemReader.readObject();
            JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
            SubjectPublicKeyInfo keyInfo = null;
            X9ECParameters ecParam = null;
            if (pemObj instanceof ASN1ObjectIdentifier) {
                ASN1ObjectIdentifier ecOID = (ASN1ObjectIdentifier)pemObj;
                ecParam = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)ecOID);
                if (ecParam == null) {
                    throw new PEMException("Unable to find EC Parameter for the given curve oid: " + ((ASN1ObjectIdentifier)pemObj).getId());
                }
                pemObj = pemReader.readObject();
            } else if (pemObj instanceof X9ECParameters) {
                ecParam = (X9ECParameters)pemObj;
                pemObj = pemReader.readObject();
            }
            keyInfo = pemObj instanceof X509CertificateHolder ? ((X509CertificateHolder)pemObj).getSubjectPublicKeyInfo() : (SubjectPublicKeyInfo)pemObj;
            publicKey = pemConverter.getPublicKey(keyInfo);
            if (ecParam != null && ECDSA.equals(publicKey.getAlgorithm())) {
                ECParameterSpec ecSpec = new ECParameterSpec(ecParam.getCurve(), ecParam.getG(), ecParam.getN(), ecParam.getH(), ecParam.getSeed());
                KeyFactory keyFactory = KeyFactory.getInstance(ECDSA, "BC");
                ECPublicKeySpec keySpec = new ECPublicKeySpec(((BCECPublicKey)publicKey).getQ(), ecSpec);
                publicKey = keyFactory.generatePublic((KeySpec)keySpec);
            }
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new Exception(e);
        }
        return publicKey;
    }

    private PrivateKey loadPrivateKey(byte[] keyBytes) throws Exception {
        StringReader keyReader = new StringReader(new String(keyBytes));
        Key privateKey = null;
        try (PEMParser pemReader = new PEMParser((Reader)keyReader);){
            X9ECParameters ecParam = null;
            Object pemObj = pemReader.readObject();
            if (pemObj instanceof ASN1ObjectIdentifier) {
                ASN1ObjectIdentifier ecOID = (ASN1ObjectIdentifier)pemObj;
                ecParam = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)ecOID);
                if (ecParam == null) {
                    throw new PEMException("Unable to find EC Parameter for the given curve oid: " + ecOID.getId());
                }
                pemObj = pemReader.readObject();
            } else if (pemObj instanceof X9ECParameters) {
                ecParam = (X9ECParameters)pemObj;
                pemObj = pemReader.readObject();
            }
            if (pemObj instanceof PEMKeyPair) {
                PrivateKeyInfo pKeyInfo = ((PEMKeyPair)pemObj).getPrivateKeyInfo();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                privateKey = pemConverter.getPrivateKey(pKeyInfo);
            }
            if (ecParam != null && ECDSA.equals(privateKey.getAlgorithm())) {
                ECParameterSpec ecSpec = new ECParameterSpec(ecParam.getCurve(), ecParam.getG(), ecParam.getN(), ecParam.getH(), ecParam.getSeed());
                KeyFactory keyFactory = KeyFactory.getInstance(ECDSA, "BC");
                ECPrivateKeySpec keySpec = new ECPrivateKeySpec(((BCECPrivateKey)privateKey).getS(), ecSpec);
                privateKey = keyFactory.generatePrivate((KeySpec)keySpec);
            }
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        return privateKey;
    }

    @Override
    public synchronized void addPublicKeyCipher(Set<String> keyNames, CryptoKeyReader keyReader) throws PulsarClientException.CryptoException {
        this.dataKey = keyGenerator.generateKey();
        for (String key : keyNames) {
            this.addPublicKeyCipher(key, keyReader);
        }
    }

    private void addPublicKeyCipher(String keyName, CryptoKeyReader keyReader) throws PulsarClientException.CryptoException {
        byte[] encryptedKey;
        PublicKey pubKey;
        if (keyName == null || keyReader == null) {
            throw new PulsarClientException.CryptoException("Keyname or KeyReader is null");
        }
        EncryptionKeyInfo keyInfo = keyReader.getPublicKey(keyName, null);
        try {
            pubKey = this.loadPublicKey(keyInfo.getKey());
        }
        catch (Exception e) {
            String msg = this.logCtx + "Failed to load public key " + keyName + ". " + e.getMessage();
            log.error(msg);
            throw new PulsarClientException.CryptoException(msg);
        }
        Cipher dataKeyCipher = null;
        try {
            if (RSA.equals(pubKey.getAlgorithm())) {
                dataKeyCipher = Cipher.getInstance(RSA_TRANS, "BC");
            } else if (ECDSA.equals(pubKey.getAlgorithm())) {
                dataKeyCipher = Cipher.getInstance(ECIES, "BC");
            } else {
                String msg = this.logCtx + "Unsupported key type " + pubKey.getAlgorithm() + " for key " + keyName;
                log.error(msg);
                throw new PulsarClientException.CryptoException(msg);
            }
            dataKeyCipher.init(1, pubKey);
            encryptedKey = dataKeyCipher.doFinal(this.dataKey.getEncoded());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error("{} Failed to encrypt data key {}. {}", new Object[]{this.logCtx, keyName, e.getMessage()});
            throw new PulsarClientException.CryptoException(e.getMessage());
        }
        EncryptionKeyInfo eki = new EncryptionKeyInfo(encryptedKey, keyInfo.getMetadata());
        this.encryptedDataKeyMap.put(keyName, eki);
    }

    @Override
    public boolean removeKeyCipher(String keyName) {
        if (keyName == null) {
            return false;
        }
        this.encryptedDataKeyMap.remove(keyName);
        return true;
    }

    @Override
    public synchronized void encrypt(Set<String> encKeys, CryptoKeyReader keyReader, Supplier<MessageMetadata> messageMetadataBuilderSupplier, ByteBuffer payload, ByteBuffer outBuffer) throws PulsarClientException {
        MessageMetadata msgMetadata = messageMetadataBuilderSupplier.get();
        if (encKeys.isEmpty()) {
            outBuffer.put(payload);
            outBuffer.flip();
            return;
        }
        for (String keyName : encKeys) {
            EncryptionKeyInfo keyInfo;
            if (this.encryptedDataKeyMap.get(keyName) == null) {
                this.addPublicKeyCipher(keyName, keyReader);
            }
            if ((keyInfo = this.encryptedDataKeyMap.get(keyName)) != null) {
                if (keyInfo.getMetadata() != null && !keyInfo.getMetadata().isEmpty()) {
                    EncryptionKeys encKey = msgMetadata.addEncryptionKey().setKey(keyName).setValue(keyInfo.getKey());
                    keyInfo.getMetadata().forEach((key, value) -> encKey.addMetadata().setKey((String)key).setValue((String)value));
                    continue;
                }
                msgMetadata.addEncryptionKey().setKey(keyName).setValue(keyInfo.getKey());
                continue;
            }
            log.error("{} Failed to find encrypted Data key for key {}.", (Object)this.logCtx, (Object)keyName);
        }
        secureRandom.nextBytes(this.iv);
        GCMParameterSpec gcmParam = new GCMParameterSpec(128, this.iv);
        msgMetadata.setEncryptionParam(this.iv);
        try {
            this.cipher.init(1, (Key)this.dataKey, gcmParam);
            int maxLength = this.cipher.getOutputSize(payload.remaining());
            if (outBuffer.remaining() < maxLength) {
                throw new IllegalArgumentException("Outbuffer has not enough space available");
            }
            int bytesStored = this.cipher.doFinal(payload, outBuffer);
            outBuffer.flip();
            outBuffer.limit(bytesStored);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            log.error("{} Failed to encrypt message. {}", (Object)this.logCtx, (Object)e);
            throw new PulsarClientException.CryptoException(e.getMessage());
        }
    }

    private boolean decryptDataKey(String keyName, byte[] encryptedDataKey, List<KeyValue> encKeyMeta, CryptoKeyReader keyReader) {
        PrivateKey privateKey;
        HashMap<String, String> keyMeta = new HashMap<String, String>();
        encKeyMeta.forEach(kv -> keyMeta.put(kv.getKey(), kv.getValue()));
        EncryptionKeyInfo keyInfo = keyReader.getPrivateKey(keyName, keyMeta);
        try {
            privateKey = this.loadPrivateKey(keyInfo.getKey());
            if (privateKey == null) {
                log.error("{} Failed to load private key {}.", (Object)this.logCtx, (Object)keyName);
                return false;
            }
        }
        catch (Exception e) {
            log.error("{} Failed to decrypt data key {} to decrypt messages {}", new Object[]{this.logCtx, keyName, e.getMessage()});
            return false;
        }
        Cipher dataKeyCipher = null;
        byte[] dataKeyValue = null;
        byte[] keyDigest = null;
        try {
            if (RSA.equals(privateKey.getAlgorithm())) {
                dataKeyCipher = Cipher.getInstance(RSA_TRANS, "BC");
            } else if (ECDSA.equals(privateKey.getAlgorithm())) {
                dataKeyCipher = Cipher.getInstance(ECIES, "BC");
            } else {
                log.error("Unsupported key type {} for key {}.", (Object)privateKey.getAlgorithm(), (Object)keyName);
                return false;
            }
            dataKeyCipher.init(2, privateKey);
            dataKeyValue = dataKeyCipher.doFinal(encryptedDataKey);
            keyDigest = this.digest.digest(encryptedDataKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error("{} Failed to decrypt data key {} to decrypt messages {}", new Object[]{this.logCtx, keyName, e.getMessage()});
            return false;
        }
        this.dataKey = new SecretKeySpec(dataKeyValue, "AES");
        this.dataKeyCache.put(ByteBuffer.wrap(keyDigest), this.dataKey);
        return true;
    }

    private boolean decryptData(SecretKey dataKeySecret, MessageMetadata msgMetadata, ByteBuffer payload, ByteBuffer targetBuffer) {
        this.iv = msgMetadata.getEncryptionParam();
        GCMParameterSpec gcmParams = new GCMParameterSpec(128, this.iv);
        try {
            this.cipher.init(2, (Key)dataKeySecret, gcmParams);
            int maxLength = this.cipher.getOutputSize(payload.remaining());
            if (targetBuffer.remaining() < maxLength) {
                throw new IllegalArgumentException("Target buffer size is too small");
            }
            int decryptedSize = this.cipher.doFinal(payload, targetBuffer);
            targetBuffer.flip();
            targetBuffer.limit(decryptedSize);
            return true;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            log.error("{} Failed to decrypt message {}", (Object)this.logCtx, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public int getMaxOutputSize(int inputLen) {
        return inputLen + Math.max(inputLen, 512);
    }

    private boolean getKeyAndDecryptData(MessageMetadata msgMetadata, ByteBuffer payload, ByteBuffer targetBuffer) {
        List<EncryptionKeys> encKeys = msgMetadata.getEncryptionKeysList();
        for (int i = 0; i < encKeys.size(); ++i) {
            byte[] msgDataKey = encKeys.get(i).getValue();
            byte[] keyDigest = this.digest.digest(msgDataKey);
            SecretKey storedSecretKey = (SecretKey)this.dataKeyCache.getIfPresent(ByteBuffer.wrap(keyDigest));
            if (storedSecretKey != null) {
                if (!this.decryptData(storedSecretKey, msgMetadata, payload, targetBuffer)) continue;
                return true;
            }
            log.debug("{} Failed to decrypt data or data key is not in cache. Will attempt to refresh", (Object)this.logCtx);
        }
        return false;
    }

    @Override
    public boolean decrypt(Supplier<MessageMetadata> messageMetadataSupplier, ByteBuffer payload, ByteBuffer outBuffer, CryptoKeyReader keyReader) {
        MessageMetadata msgMetadata = messageMetadataSupplier.get();
        if (this.dataKey != null && this.getKeyAndDecryptData(msgMetadata, payload, outBuffer)) {
            return true;
        }
        List<EncryptionKeys> encKeys = msgMetadata.getEncryptionKeysList();
        EncryptionKeys encKeyInfo = encKeys.stream().filter(kbv -> {
            byte[] encDataKey = kbv.getValue();
            List<KeyValue> encKeyMeta = kbv.getMetadatasList();
            return this.decryptDataKey(kbv.getKey(), encDataKey, encKeyMeta, keyReader);
        }).findFirst().orElse(null);
        if (encKeyInfo == null || this.dataKey == null) {
            return false;
        }
        return this.getKeyAndDecryptData(msgMetadata, payload, outBuffer);
    }

    static {
        SecureRandom rand = null;
        try {
            rand = SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException nsa) {
            rand = new SecureRandom();
        }
        secureRandom = rand;
        secureRandom.nextBytes(new byte[12]);
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

