/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.List;
import lombok.NonNull;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessagePayload;
import org.apache.pulsar.client.api.MessagePayloadContext;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.BatchMessageAcker;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.MessagePayloadUtils;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.SingleMessageMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SafeCollectionUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.BitSetRecyclable;

public class MessagePayloadContextImpl
implements MessagePayloadContext {
    private static final Recycler<MessagePayloadContextImpl> RECYCLER = new Recycler<MessagePayloadContextImpl>(){

        @Override
        protected MessagePayloadContextImpl newObject(Recycler.Handle<MessagePayloadContextImpl> handle) {
            return new MessagePayloadContextImpl(handle);
        }
    };
    private final Recycler.Handle<MessagePayloadContextImpl> recyclerHandle;
    private BrokerEntryMetadata brokerEntryMetadata;
    private MessageMetadata messageMetadata;
    private SingleMessageMetadata singleMessageMetadata;
    private MessageIdImpl messageId;
    private ConsumerImpl<?> consumer;
    private int redeliveryCount;
    private BatchMessageAcker acker;
    private BitSetRecyclable ackBitSet;

    private MessagePayloadContextImpl(Recycler.Handle<MessagePayloadContextImpl> handle) {
        this.recyclerHandle = handle;
    }

    public static MessagePayloadContextImpl get(BrokerEntryMetadata brokerEntryMetadata, @NonNull MessageMetadata messageMetadata, @NonNull MessageIdImpl messageId, @NonNull ConsumerImpl<?> consumer, int redeliveryCount, List<Long> ackSet) {
        if (messageMetadata == null) {
            throw new NullPointerException("messageMetadata is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        MessagePayloadContextImpl context = RECYCLER.get();
        context.brokerEntryMetadata = brokerEntryMetadata;
        context.messageMetadata = messageMetadata;
        context.singleMessageMetadata = new SingleMessageMetadata();
        context.messageId = messageId;
        context.consumer = consumer;
        context.redeliveryCount = redeliveryCount;
        context.acker = BatchMessageAcker.newAcker(context.getNumMessages());
        context.ackBitSet = ackSet != null && ackSet.size() > 0 ? BitSetRecyclable.valueOf(SafeCollectionUtils.longListToArray(ackSet)) : null;
        return context;
    }

    public void recycle() {
        this.brokerEntryMetadata = null;
        this.messageMetadata = null;
        this.singleMessageMetadata = null;
        this.messageId = null;
        this.consumer = null;
        this.redeliveryCount = 0;
        this.acker = null;
        if (this.ackBitSet != null) {
            this.ackBitSet.recycle();
            this.ackBitSet = null;
        }
    }

    @Override
    public String getProperty(String key) {
        for (KeyValue keyValue : this.messageMetadata.getPropertiesList()) {
            if (!keyValue.hasKey() || !keyValue.getKey().equals(key)) continue;
            return keyValue.getValue();
        }
        return null;
    }

    @Override
    public int getNumMessages() {
        return this.messageMetadata.getNumMessagesInBatch();
    }

    @Override
    public boolean isBatch() {
        return this.consumer.isBatch(this.messageMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Message<T> getMessageAt(int index, int numMessages, MessagePayload payload, boolean containMetadata, Schema<T> schema) {
        ByteBuf payloadBuffer = MessagePayloadUtils.convertToByteBuf(payload);
        try {
            MessageImpl<T> messageImpl = this.consumer.newSingleMessage(index, numMessages, this.brokerEntryMetadata, this.messageMetadata, this.singleMessageMetadata, payloadBuffer, this.messageId, schema, containMetadata, this.ackBitSet, this.acker, this.redeliveryCount);
            return messageImpl;
        }
        finally {
            payloadBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Message<T> asSingleMessage(MessagePayload payload, Schema<T> schema) {
        ByteBuf payloadBuffer = MessagePayloadUtils.convertToByteBuf(payload);
        try {
            MessageImpl<T> messageImpl = this.consumer.newMessage(this.messageId, this.brokerEntryMetadata, this.messageMetadata, payloadBuffer, schema, this.redeliveryCount);
            return messageImpl;
        }
        finally {
            payloadBuffer.release();
        }
    }
}

