/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pulsar.client.api.KeySharedMode;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class KeySharedPolicy {
    protected KeySharedMode keySharedMode;
    protected boolean allowOutOfOrderDelivery = false;
    public static final int DEFAULT_HASH_RANGE_SIZE = 65536;

    public static KeySharedPolicyAutoSplit autoSplitHashRange() {
        return new KeySharedPolicyAutoSplit();
    }

    public static KeySharedPolicySticky stickyHashRange() {
        return new KeySharedPolicySticky();
    }

    public abstract void validate();

    public KeySharedPolicy setAllowOutOfOrderDelivery(boolean allowOutOfOrderDelivery) {
        this.allowOutOfOrderDelivery = allowOutOfOrderDelivery;
        return this;
    }

    public boolean isAllowOutOfOrderDelivery() {
        return this.allowOutOfOrderDelivery;
    }

    public KeySharedMode getKeySharedMode() {
        return this.keySharedMode;
    }

    public int getHashRangeTotal() {
        return 65536;
    }

    public static class KeySharedPolicyAutoSplit
    extends KeySharedPolicy {
        KeySharedPolicyAutoSplit() {
            this.keySharedMode = KeySharedMode.AUTO_SPLIT;
        }

        @Override
        public void validate() {
        }
    }

    public static class KeySharedPolicySticky
    extends KeySharedPolicy {
        protected List<Range> ranges;

        KeySharedPolicySticky() {
            this.keySharedMode = KeySharedMode.STICKY;
            this.ranges = new ArrayList<Range>();
        }

        public KeySharedPolicySticky ranges(List<Range> ranges) {
            this.ranges.addAll(ranges);
            return this;
        }

        public KeySharedPolicySticky ranges(Range ... ranges) {
            this.ranges.addAll(Arrays.asList(ranges));
            return this;
        }

        @Override
        public void validate() {
            if (this.ranges.isEmpty()) {
                throw new IllegalArgumentException("Ranges for KeyShared policy must not be empty.");
            }
            for (int i = 0; i < this.ranges.size(); ++i) {
                Range range1 = this.ranges.get(i);
                if (range1.getStart() < 0 || range1.getEnd() >= 65536) {
                    throw new IllegalArgumentException("Ranges must be [0, 65535] but provided range is " + range1);
                }
                for (int j = 0; j < this.ranges.size(); ++j) {
                    Range range2 = this.ranges.get(j);
                    if (i == j || range1.intersect(range2) == null) continue;
                    throw new IllegalArgumentException("Ranges for KeyShared policy with overlap between " + range1 + " and " + range2);
                }
            }
        }

        public List<Range> getRanges() {
            return this.ranges;
        }
    }
}

