/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.type.TypeReference;

public class DynamicConfigurationResources
extends BaseResources<Map<String, String>> {
    private static final String BROKER_SERVICE_CONFIGURATION_PATH = "/admin/configuration";

    public DynamicConfigurationResources(MetadataStore store, int operationTimeoutSec) {
        super(store, new TypeReference<Map<String, String>>(){}, operationTimeoutSec);
    }

    public CompletableFuture<Optional<Map<String, String>>> getDynamicConfigurationAsync() {
        return this.getAsync(BROKER_SERVICE_CONFIGURATION_PATH);
    }

    public Map<String, String> getDynamicConfiguration() throws MetadataStoreException {
        return this.get(BROKER_SERVICE_CONFIGURATION_PATH).orElse(Collections.emptyMap());
    }

    public void setDynamicConfigurationWithCreate(Function<Optional<Map<String, String>>, Map<String, String>> createFunction) throws MetadataStoreException {
        super.setWithCreate(BROKER_SERVICE_CONFIGURATION_PATH, createFunction);
    }

    public void setDynamicConfiguration(Function<Map<String, String>, Map<String, String>> updateFunction) throws MetadataStoreException {
        super.set(BROKER_SERVICE_CONFIGURATION_PATH, updateFunction);
    }

    public boolean isDynamicConfigurationPath(String path) {
        return BROKER_SERVICE_CONFIGURATION_PATH.equals(path);
    }
}

