/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.pulsar.broker.loadbalance.LeaderBroker;
import org.apache.pulsar.metadata.api.coordination.CoordinationService;
import org.apache.pulsar.metadata.api.coordination.LeaderElection;
import org.apache.pulsar.metadata.api.coordination.LeaderElectionState;

public class LeaderElectionService
implements AutoCloseable {
    private static final String ELECTION_ROOT = "/loadbalance/leader";
    private final LeaderElection<LeaderBroker> leaderElection;
    private final LeaderBroker localValue;

    public LeaderElectionService(CoordinationService cs, String localWebServiceAddress, Consumer<LeaderElectionState> listener) {
        this.leaderElection = cs.getLeaderElection(LeaderBroker.class, ELECTION_ROOT, listener);
        this.localValue = new LeaderBroker(localWebServiceAddress);
    }

    public void start() {
        this.leaderElection.elect(this.localValue).join();
    }

    @Override
    public void close() throws Exception {
        this.leaderElection.close();
    }

    public CompletableFuture<Optional<LeaderBroker>> readCurrentLeader() {
        return this.leaderElection.getLeaderValue();
    }

    public Optional<LeaderBroker> getCurrentLeader() {
        return this.leaderElection.getLeaderValueIfPresent();
    }

    public boolean isLeader() {
        return this.leaderElection.getState() == LeaderElectionState.Leading;
    }
}

