/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.pulsar.broker.admin.impl.BrokerStatsBase;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.core.StreamingOutput;

@Path(value="/broker-stats")
@Api(value="/broker-stats", description="Stats for broker", tags={"broker-stats"})
@Produces(value={"application/json"})
public class BrokerStats
extends BrokerStatsBase {
    @Override
    @GET
    @Path(value="/topics")
    @ApiOperation(value="Get all the topic stats by namespace", response=OutputStream.class, responseContainer="OutputStream")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public StreamingOutput getTopics2() throws Exception {
        return super.getTopics2();
    }

    @GET
    @Path(value="/broker-resource-availability/{tenant}/{namespace}")
    @ApiOperation(value="Broker availability report", notes="This API gives the current broker availability in percent, each resource percentage usage is calculated and thensum of all of the resource usage percent is called broker-resource-availability<br/><br/>THIS API IS ONLY FOR USE BY TESTING FOR CONFIRMING NAMESPACE ALLOCATION ALGORITHM", response=ResourceUnit.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Load-manager doesn't support operation")})
    public Map<Long, Collection<ResourceUnit>> getBrokerResourceAvailability(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalBrokerResourceAvailability(this.namespaceName);
    }
}

