/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stream.server.service;

import java.io.IOException;
import java.util.Collections;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieStateManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.utils.NetUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.server.conf.BookieConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.server.service.RegistrationServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationStateService
extends AbstractLifecycleComponent<BookieConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(RegistrationStateService.class);
    private final Endpoint myEndpoint;
    private final ServerConfiguration bkServerConf;
    private final RegistrationServiceProvider regServiceProvider;
    private RegistrationManager regManager;
    private BookieStateManager stateManager;

    public RegistrationStateService(Endpoint myEndpoint, ServerConfiguration bkServerConf, BookieConfiguration bookieConf, RegistrationServiceProvider serviceProvider, StatsLogger statsLogger) {
        super("registration-state-service", bookieConf, statsLogger);
        this.myEndpoint = myEndpoint;
        this.bkServerConf = bkServerConf;
        this.regServiceProvider = serviceProvider;
    }

    @Override
    protected void doStart() {
        if (null == this.regManager) {
            this.regManager = new ZKRegistrationManager(this.bkServerConf, this.regServiceProvider.getZkClient(), this.regServiceProvider.getRegistrationPath(), () -> {
                if (null == this.stateManager) {
                    log.warn("Registration state manager is not initialized yet");
                    return;
                }
                this.stateManager.forceToUnregistered();
                this.stateManager.registerBookie(false);
            });
            try {
                this.stateManager = new BookieStateManager(this.bkServerConf, this.statsLogger.scope("state"), () -> this.regManager, Collections.emptyList(), () -> BookieId.parse(NetUtils.endpointToString(this.myEndpoint)), BookieServiceInfo.NO_INFO);
                this.stateManager.initState();
                this.stateManager.registerBookie(true).get();
                log.info("Successfully register myself under registration path {}/{}", (Object)this.regServiceProvider.getRegistrationPath(), (Object)NetUtils.endpointToString(this.myEndpoint));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to intiailize a registration state service", e);
            }
        }
    }

    @Override
    protected void doStop() {
        if (null == this.stateManager) {
            log.info("State Manager is null, no need to stop it.");
            return;
        }
        this.stateManager.forceToShuttingDown();
        this.stateManager.forceToReadOnly();
    }

    @Override
    protected void doClose() throws IOException {
        if (null != this.stateManager) {
            this.stateManager.close();
        }
        if (null != this.regManager) {
            this.regManager.close();
        }
    }
}

