/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.proto;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.protobuf.ExtensionRegistry;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.auth.AuthProviderFactoryFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.DefaultPerChannelBookieClientPool;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.PerChannelBookieClientFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.PerChannelBookieClientPool;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.tls.SecurityException;
import org.apache.pulsar.shade.org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.ByteBufList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieClientImpl
implements BookieClient,
PerChannelBookieClientFactory {
    static final Logger LOG = LoggerFactory.getLogger(BookieClientImpl.class);
    private final OrderedExecutor executor;
    private final ScheduledExecutorService scheduler;
    private final ScheduledFuture<?> timeoutFuture;
    private final EventLoopGroup eventLoopGroup;
    private final ByteBufAllocator allocator;
    final ConcurrentHashMap<BookieId, PerChannelBookieClientPool> channels = new ConcurrentHashMap();
    private final ClientAuthProvider.Factory authProviderFactory;
    private final ExtensionRegistry registry;
    private final ClientConfiguration conf;
    private final ClientConfiguration v3Conf;
    private final boolean useV3Enforced;
    private volatile boolean closed;
    private final ReentrantReadWriteLock closeLock;
    private final StatsLogger statsLogger;
    private final int numConnectionsPerBookie;
    private final BookieAddressResolver bookieAddressResolver;
    private final long bookieErrorThresholdPerInterval;

    public BookieClientImpl(ClientConfiguration conf, EventLoopGroup eventLoopGroup, ByteBufAllocator allocator, OrderedExecutor executor, ScheduledExecutorService scheduler, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) throws IOException {
        this.conf = conf;
        this.v3Conf = new ClientConfiguration(conf);
        this.v3Conf.setUseV2WireProtocol(false);
        this.useV3Enforced = conf.getUseV2WireProtocol();
        this.eventLoopGroup = eventLoopGroup;
        this.allocator = allocator;
        this.executor = executor;
        this.closed = false;
        this.closeLock = new ReentrantReadWriteLock();
        this.bookieAddressResolver = bookieAddressResolver;
        this.registry = ExtensionRegistry.newInstance();
        this.authProviderFactory = AuthProviderFactoryFactory.newClientAuthProviderFactory(conf);
        this.statsLogger = statsLogger;
        this.numConnectionsPerBookie = conf.getNumChannelsPerBookie();
        this.bookieErrorThresholdPerInterval = conf.getBookieErrorThresholdPerInterval();
        this.scheduler = scheduler;
        if (conf.getAddEntryTimeout() > 0 || conf.getReadEntryTimeout() > 0) {
            org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable monitor = org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> this.monitorPendingOperations());
            this.timeoutFuture = this.scheduler.scheduleAtFixedRate(monitor, conf.getTimeoutMonitorIntervalSec(), conf.getTimeoutMonitorIntervalSec(), TimeUnit.SECONDS);
        } else {
            this.timeoutFuture = null;
        }
    }

    private int getRc(int rc) {
        if (0 == rc) {
            return rc;
        }
        if (this.closed) {
            return -19;
        }
        return rc;
    }

    @Override
    public List<BookieId> getFaultyBookies() {
        ArrayList<BookieId> faultyBookies = Lists.newArrayList();
        for (PerChannelBookieClientPool channelPool : this.channels.values()) {
            if (!(channelPool instanceof DefaultPerChannelBookieClientPool)) continue;
            DefaultPerChannelBookieClientPool pool = (DefaultPerChannelBookieClientPool)channelPool;
            if (pool.errorCounter.getAndSet(0L) < this.bookieErrorThresholdPerInterval) continue;
            faultyBookies.add(pool.address);
        }
        return faultyBookies;
    }

    @Override
    public boolean isWritable(BookieId address, long key) {
        PerChannelBookieClientPool pcbcPool = this.lookupClient(address);
        return pcbcPool == null || pcbcPool.isWritable(key);
    }

    @Override
    public long getNumPendingRequests(BookieId address, long ledgerId) {
        PerChannelBookieClientPool pcbcPool = this.lookupClient(address);
        if (pcbcPool == null) {
            return 0L;
        }
        if (pcbcPool.isWritable(ledgerId)) {
            return pcbcPool.getNumPendingCompletionRequests();
        }
        return pcbcPool.getNumPendingCompletionRequests() | 0x4000000000000000L;
    }

    @Override
    public PerChannelBookieClient create(BookieId address, PerChannelBookieClientPool pcbcPool, SecurityHandlerFactory shFactory, boolean forceUseV3) throws SecurityException {
        StatsLogger statsLoggerForPCBC = this.statsLogger;
        if (this.conf.getLimitStatsLogging()) {
            statsLoggerForPCBC = NullStatsLogger.INSTANCE;
        }
        ClientConfiguration clientConfiguration = this.conf;
        if (forceUseV3) {
            clientConfiguration = this.v3Conf;
        }
        return new PerChannelBookieClient(clientConfiguration, this.executor, this.eventLoopGroup, this.allocator, address, statsLoggerForPCBC, this.authProviderFactory, this.registry, pcbcPool, shFactory, this.bookieAddressResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerChannelBookieClientPool lookupClient(BookieId addr) {
        PerChannelBookieClientPool clientPool = this.channels.get(addr);
        if (null == clientPool) {
            this.closeLock.readLock().lock();
            try {
                if (this.closed) {
                    PerChannelBookieClientPool perChannelBookieClientPool = null;
                    return perChannelBookieClientPool;
                }
                DefaultPerChannelBookieClientPool newClientPool = new DefaultPerChannelBookieClientPool(this.conf, this, addr, this.numConnectionsPerBookie);
                PerChannelBookieClientPool oldClientPool = this.channels.putIfAbsent(addr, newClientPool);
                if (null == oldClientPool) {
                    clientPool = newClientPool;
                    clientPool.initialize();
                } else {
                    clientPool = oldClientPool;
                    newClientPool.close(false);
                }
            }
            catch (SecurityException e) {
                LOG.error("Security Exception in creating new default PCBC pool: ", (Throwable)e);
                PerChannelBookieClientPool perChannelBookieClientPool = null;
                return perChannelBookieClientPool;
            }
            finally {
                this.closeLock.readLock().unlock();
            }
        }
        return clientPool;
    }

    @Override
    public void forceLedger(BookieId addr, long ledgerId, BookkeeperInternalCallbacks.ForceLedgerCallback cb, Object ctx) {
        PerChannelBookieClientPool client = this.lookupClient(addr);
        if (client == null) {
            cb.forceLedgerComplete(this.getRc(-8), ledgerId, addr, ctx);
            return;
        }
        client.obtain((rc, pcbc) -> {
            if (rc != 0) {
                try {
                    this.executor.executeOrdered(ledgerId, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> cb.forceLedgerComplete(rc, ledgerId, addr, ctx)));
                }
                catch (RejectedExecutionException re) {
                    cb.forceLedgerComplete(this.getRc(-15), ledgerId, addr, ctx);
                }
            } else {
                pcbc.forceLedger(ledgerId, cb, ctx);
            }
        }, ledgerId);
    }

    @Override
    public void writeLac(BookieId addr, long ledgerId, byte[] masterKey, long lac, ByteBufList toSend, BookkeeperInternalCallbacks.WriteLacCallback cb, Object ctx) {
        PerChannelBookieClientPool client = this.lookupClient(addr);
        if (client == null) {
            cb.writeLacComplete(this.getRc(-8), ledgerId, addr, ctx);
            return;
        }
        toSend.retain();
        client.obtain((rc, pcbc) -> {
            if (rc != 0) {
                try {
                    this.executor.executeOrdered(ledgerId, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> cb.writeLacComplete(rc, ledgerId, addr, ctx)));
                }
                catch (RejectedExecutionException re) {
                    cb.writeLacComplete(this.getRc(-15), ledgerId, addr, ctx);
                }
            } else {
                pcbc.writeLac(ledgerId, masterKey, lac, toSend, cb, ctx);
            }
            toSend.release();
        }, ledgerId, this.useV3Enforced);
    }

    private void completeAdd(final int rc, final long ledgerId, final long entryId, final BookieId addr, final BookkeeperInternalCallbacks.WriteCallback cb, final Object ctx) {
        try {
            this.executor.executeOrdered(ledgerId, new SafeRunnable(){

                @Override
                public void safeRun() {
                    cb.writeComplete(rc, ledgerId, entryId, addr, ctx);
                }

                public String toString() {
                    return String.format("CompleteWrite(ledgerId=%d, entryId=%d, addr=%s)", ledgerId, entryId, addr);
                }
            });
        }
        catch (RejectedExecutionException ree) {
            cb.writeComplete(this.getRc(-15), ledgerId, entryId, addr, ctx);
        }
    }

    @Override
    public void addEntry(BookieId addr, long ledgerId, byte[] masterKey, long entryId, ByteBufList toSend, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, int options, boolean allowFastFail, EnumSet<WriteFlag> writeFlags) {
        PerChannelBookieClientPool client = this.lookupClient(addr);
        if (client == null) {
            this.completeAdd(this.getRc(-8), ledgerId, entryId, addr, cb, ctx);
            return;
        }
        toSend.retain();
        client.obtain(ChannelReadyForAddEntryCallback.create(this, toSend, ledgerId, entryId, addr, ctx, cb, options, masterKey, allowFastFail, writeFlags), ledgerId);
    }

    @Override
    public CompletableFuture<AvailabilityOfEntriesOfLedger> getListOfEntriesOfLedger(BookieId address, long ledgerId) {
        BookkeeperInternalCallbacks.FutureGetListOfEntriesOfLedger futureResult = new BookkeeperInternalCallbacks.FutureGetListOfEntriesOfLedger(ledgerId);
        PerChannelBookieClientPool client = this.lookupClient(address);
        if (client == null) {
            futureResult.getListOfEntriesOfLedgerComplete(this.getRc(-8), ledgerId, null);
            return futureResult;
        }
        client.obtain((rc, pcbc) -> {
            if (rc != 0) {
                try {
                    this.executor.executeOrdered(ledgerId, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> futureResult.getListOfEntriesOfLedgerComplete(rc, ledgerId, null)));
                }
                catch (RejectedExecutionException re) {
                    futureResult.getListOfEntriesOfLedgerComplete(this.getRc(-15), ledgerId, null);
                }
            } else {
                pcbc.getListOfEntriesOfLedger(ledgerId, futureResult);
            }
        }, ledgerId);
        return futureResult;
    }

    private void completeRead(final int rc, final long ledgerId, final long entryId, final ByteBuf entry, final BookkeeperInternalCallbacks.ReadEntryCallback cb, final Object ctx) {
        try {
            this.executor.executeOrdered(ledgerId, new SafeRunnable(){

                @Override
                public void safeRun() {
                    cb.readEntryComplete(rc, ledgerId, entryId, entry, ctx);
                }
            });
        }
        catch (RejectedExecutionException ree) {
            cb.readEntryComplete(this.getRc(-15), ledgerId, entryId, entry, ctx);
        }
    }

    @Override
    public void readLac(BookieId addr, long ledgerId, BookkeeperInternalCallbacks.ReadLacCallback cb, Object ctx) {
        PerChannelBookieClientPool client = this.lookupClient(addr);
        if (client == null) {
            cb.readLacComplete(this.getRc(-8), ledgerId, null, null, ctx);
            return;
        }
        client.obtain((rc, pcbc) -> {
            if (rc != 0) {
                try {
                    this.executor.executeOrdered(ledgerId, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> cb.readLacComplete(rc, ledgerId, null, null, ctx)));
                }
                catch (RejectedExecutionException re) {
                    cb.readLacComplete(this.getRc(-15), ledgerId, null, null, ctx);
                }
            } else {
                pcbc.readLac(ledgerId, cb, ctx);
            }
        }, ledgerId, this.useV3Enforced);
    }

    @Override
    public void readEntry(BookieId addr, long ledgerId, long entryId, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx, int flags) {
        this.readEntry(addr, ledgerId, entryId, cb, ctx, flags, null);
    }

    @Override
    public void readEntry(BookieId addr, long ledgerId, long entryId, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx, int flags, byte[] masterKey) {
        this.readEntry(addr, ledgerId, entryId, cb, ctx, flags, masterKey, false);
    }

    @Override
    public void readEntry(BookieId addr, long ledgerId, long entryId, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx, int flags, byte[] masterKey, boolean allowFastFail) {
        PerChannelBookieClientPool client = this.lookupClient(addr);
        if (client == null) {
            cb.readEntryComplete(this.getRc(-8), ledgerId, entryId, null, ctx);
            return;
        }
        client.obtain((rc, pcbc) -> {
            if (rc != 0) {
                this.completeRead(rc, ledgerId, entryId, null, cb, ctx);
            } else {
                pcbc.readEntry(ledgerId, entryId, cb, ctx, flags, masterKey, allowFastFail);
            }
        }, ledgerId);
    }

    @Override
    public void readEntryWaitForLACUpdate(BookieId addr, long ledgerId, long entryId, long previousLAC, long timeOutInMillis, boolean piggyBackEntry, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        PerChannelBookieClientPool client = this.lookupClient(addr);
        if (client == null) {
            this.completeRead(-8, ledgerId, entryId, null, cb, ctx);
            return;
        }
        client.obtain((rc, pcbc) -> {
            if (rc != 0) {
                this.completeRead(rc, ledgerId, entryId, null, cb, ctx);
            } else {
                pcbc.readEntryWaitForLACUpdate(ledgerId, entryId, previousLAC, timeOutInMillis, piggyBackEntry, cb, ctx);
            }
        }, ledgerId);
    }

    @Override
    public void getBookieInfo(BookieId addr, long requested, BookkeeperInternalCallbacks.GetBookieInfoCallback cb, Object ctx) {
        PerChannelBookieClientPool client = this.lookupClient(addr);
        if (client == null) {
            cb.getBookieInfoComplete(this.getRc(-8), new BookieInfoReader.BookieInfo(), ctx);
            return;
        }
        client.obtain((rc, pcbc) -> {
            if (rc != 0) {
                try {
                    this.executor.submit(org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> cb.getBookieInfoComplete(rc, new BookieInfoReader.BookieInfo(), ctx)));
                }
                catch (RejectedExecutionException re) {
                    cb.getBookieInfoComplete(this.getRc(-15), new BookieInfoReader.BookieInfo(), ctx);
                }
            } else {
                pcbc.getBookieInfo(requested, cb, ctx);
            }
        }, requested, this.useV3Enforced);
    }

    private void monitorPendingOperations() {
        for (PerChannelBookieClientPool clientPool : this.channels.values()) {
            clientPool.checkTimeoutOnPendingOperations();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closeLock.writeLock().lock();
        try {
            this.closed = true;
            for (PerChannelBookieClientPool pool : this.channels.values()) {
                pool.close(true);
            }
            this.channels.clear();
            this.authProviderFactory.close();
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
            }
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
    }

    public static void main(String[] args) throws NumberFormatException, IOException, InterruptedException {
        if (args.length != 3) {
            System.err.println("USAGE: BookieClient bookieHost port ledger#");
            return;
        }
        BookkeeperInternalCallbacks.WriteCallback cb = new BookkeeperInternalCallbacks.WriteCallback(){

            @Override
            public void writeComplete(int rc, long ledger, long entry, BookieId addr, Object ctx) {
                Counter counter = (Counter)ctx;
                counter.dec();
                if (rc != 0) {
                    System.out.println("rc = " + rc + " for " + entry + "@" + ledger);
                }
            }
        };
        Counter counter = new Counter();
        byte[] hello = "hello".getBytes(StandardCharsets.UTF_8);
        long ledger = Long.parseLong(args[2]);
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(1);
        Object executor = OrderedExecutor.newBuilder().name("BookieClientWorker").numThreads(1).build();
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("BookKeeperClientScheduler"));
        BookieClientImpl bc = new BookieClientImpl(new ClientConfiguration(), eventLoopGroup, null, (OrderedExecutor)executor, scheduler, NullStatsLogger.INSTANCE, b -> (BookieSocketAddress)BookieSocketAddress.class.cast(b));
        BookieId addr = new BookieSocketAddress(args[0], Integer.parseInt(args[1])).toBookieId();
        for (int i = 0; i < 100000; ++i) {
            counter.inc();
            bc.addEntry(addr, ledger, new byte[0], i, ByteBufList.get(Unpooled.wrappedBuffer(hello)), cb, counter, 0, false, WriteFlag.NONE);
        }
        counter.wait(0);
        System.out.println("Total = " + counter.total());
        scheduler.shutdown();
        eventLoopGroup.shutdownGracefully();
        ((OrderedExecutor)executor).shutdown();
    }

    private static class Counter {
        int i;
        int total;

        private Counter() {
        }

        synchronized void inc() {
            ++this.i;
            ++this.total;
        }

        synchronized void dec() {
            --this.i;
            this.notifyAll();
        }

        synchronized void wait(int limit) throws InterruptedException {
            while (this.i > limit) {
                this.wait();
            }
        }

        synchronized int total() {
            return this.total;
        }
    }

    private static class ChannelReadyForAddEntryCallback
    implements BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> {
        private final Recycler.Handle<ChannelReadyForAddEntryCallback> recyclerHandle;
        private BookieClientImpl bookieClient;
        private ByteBufList toSend;
        private long ledgerId;
        private long entryId;
        private BookieId addr;
        private Object ctx;
        private BookkeeperInternalCallbacks.WriteCallback cb;
        private int options;
        private byte[] masterKey;
        private boolean allowFastFail;
        private EnumSet<WriteFlag> writeFlags;
        private static final Recycler<ChannelReadyForAddEntryCallback> RECYCLER = new Recycler<ChannelReadyForAddEntryCallback>(){

            @Override
            protected ChannelReadyForAddEntryCallback newObject(Recycler.Handle<ChannelReadyForAddEntryCallback> recyclerHandle) {
                return new ChannelReadyForAddEntryCallback(recyclerHandle);
            }
        };

        static ChannelReadyForAddEntryCallback create(BookieClientImpl bookieClient, ByteBufList toSend, long ledgerId, long entryId, BookieId addr, Object ctx, BookkeeperInternalCallbacks.WriteCallback cb, int options, byte[] masterKey, boolean allowFastFail, EnumSet<WriteFlag> writeFlags) {
            ChannelReadyForAddEntryCallback callback = RECYCLER.get();
            callback.bookieClient = bookieClient;
            callback.toSend = toSend;
            callback.ledgerId = ledgerId;
            callback.entryId = entryId;
            callback.addr = addr;
            callback.ctx = ctx;
            callback.cb = cb;
            callback.options = options;
            callback.masterKey = masterKey;
            callback.allowFastFail = allowFastFail;
            callback.writeFlags = writeFlags;
            return callback;
        }

        @Override
        public void operationComplete(int rc, PerChannelBookieClient pcbc) {
            if (rc != 0) {
                this.bookieClient.completeAdd(rc, this.ledgerId, this.entryId, this.addr, this.cb, this.ctx);
            } else {
                pcbc.addEntry(this.ledgerId, this.masterKey, this.entryId, this.toSend, this.cb, this.ctx, this.options, this.allowFastFail, this.writeFlags);
            }
            this.toSend.release();
            this.recycle();
        }

        private ChannelReadyForAddEntryCallback(Recycler.Handle<ChannelReadyForAddEntryCallback> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        public void recycle() {
            this.bookieClient = null;
            this.toSend = null;
            this.ledgerId = -1L;
            this.entryId = -1L;
            this.addr = null;
            this.ctx = null;
            this.cb = null;
            this.options = -1;
            this.masterKey = null;
            this.allowFastFail = false;
            this.writeFlags = null;
            this.recyclerHandle.recycle(this);
        }
    }
}

