/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.swagger.models;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.apache.pulsar.shade.io.swagger.models.Model;
import org.apache.pulsar.shade.io.swagger.models.properties.Property;
import org.apache.pulsar.shade.io.swagger.models.utils.PropertyModelConverter;

public class Response {
    private String description;
    private Model schemaAsModel;
    private Property schemaAsProperty;
    private Map<String, Object> examples;
    private Map<String, Property> headers;
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();

    public Response description(String description) {
        this.setDescription(description);
        return this;
    }

    public Response example(String type, Object example) {
        if (this.examples == null) {
            this.examples = new LinkedHashMap<String, Object>();
        }
        this.examples.put(type, example);
        return this;
    }

    public Response header(String name, Property property) {
        this.addHeader(name, property);
        return this;
    }

    public Response headers(Map<String, Property> headers) {
        this.headers = headers;
        return this;
    }

    public Response vendorExtension(String key, Object obj) {
        this.setVendorExtension(key, obj);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public Property getSchema() {
        if (this.schemaAsProperty == null && this.schemaAsModel != null) {
            return new PropertyModelConverter().modelToProperty(this.schemaAsModel);
        }
        return this.schemaAsProperty;
    }

    @Deprecated
    public void setSchema(Property schema) {
        this.schemaAsProperty = schema;
    }

    @Deprecated
    public Response schema(Property property) {
        this.setSchema(property);
        return this;
    }

    public Model getResponseSchema() {
        if (this.schemaAsModel == null && this.schemaAsProperty != null) {
            return new PropertyModelConverter().propertyToModel(this.schemaAsProperty);
        }
        return this.schemaAsModel;
    }

    public void setResponseSchema(Model model) {
        this.schemaAsModel = model;
    }

    public Response responseSchema(Model model) {
        this.setResponseSchema(model);
        return this;
    }

    public Map<String, Object> getExamples() {
        return this.examples;
    }

    public void setExamples(Map<String, Object> examples) {
        this.examples = examples;
    }

    public Map<String, Property> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Property> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, Property property) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Property>();
        }
        this.headers.put(key, property);
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String name, Object value) {
        if (name.startsWith("x-")) {
            this.vendorExtensions.put(name, value);
        }
    }

    public void setVendorExtensions(Map<String, Object> vendorExtensions) {
        this.vendorExtensions = vendorExtensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response response = (Response)o;
        if (this.description != null ? !this.description.equals(response.description) : response.description != null) {
            return false;
        }
        if (this.schemaAsModel != null ? !this.schemaAsModel.equals(response.schemaAsModel) : response.schemaAsModel != null) {
            return false;
        }
        if (this.schemaAsProperty != null ? !this.schemaAsProperty.equals(response.schemaAsProperty) : response.schemaAsProperty != null) {
            return false;
        }
        if (this.examples != null ? !this.examples.equals(response.examples) : response.examples != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(response.headers) : response.headers != null) {
            return false;
        }
        return this.vendorExtensions != null ? this.vendorExtensions.equals(response.vendorExtensions) : response.vendorExtensions == null;
    }

    public int hashCode() {
        int result = this.description != null ? this.description.hashCode() : 0;
        result = 31 * result + (this.schemaAsModel != null ? this.schemaAsModel.hashCode() : 0);
        result = 31 * result + (this.schemaAsProperty != null ? this.schemaAsProperty.hashCode() : 0);
        result = 31 * result + (this.examples != null ? this.examples.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.vendorExtensions != null ? this.vendorExtensions.hashCode() : 0);
        return result;
    }
}

