/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.shade.javax.servlet.Filter;
import org.apache.pulsar.shade.javax.servlet.FilterChain;
import org.apache.pulsar.shade.javax.servlet.FilterConfig;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.ServletRequest;
import org.apache.pulsar.shade.javax.servlet.ServletResponse;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandlerFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHandlerFilter.class);
    private static final String BROKER_ADDRESS_HEADER_NAME = "broker-address";
    private final String brokerAddress;
    private final BrokerInterceptor interceptor;
    private final boolean interceptorEnabled;

    public ResponseHandlerFilter(PulsarService pulsar) {
        this.brokerAddress = pulsar.getAdvertisedAddress();
        this.interceptor = pulsar.getBrokerInterceptor();
        this.interceptorEnabled = !pulsar.getConfig().getBrokerInterceptors().isEmpty();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!response.isCommitted()) {
            ((HttpServletResponse)response).addHeader(BROKER_ADDRESS_HEADER_NAME, this.brokerAddress);
        } else {
            LOG.warn("Cannot add header {} to request {} since it's already committed.", (Object)BROKER_ADDRESS_HEADER_NAME, (Object)request);
        }
        chain.doFilter(request, response);
        if (((HttpServletResponse)response).getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            try {
                ((HttpServletRequest)request).getSession(false).invalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.interceptorEnabled && !StringUtils.containsIgnoreCase(request.getContentType(), "multipart/form-data") && !StringUtils.containsIgnoreCase(request.getContentType(), "application/octet-stream")) {
            this.interceptor.onWebserviceResponse(request, response);
        }
    }

    @Override
    public void init(FilterConfig arg) throws ServletException {
    }

    @Override
    public void destroy() {
    }
}

