/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import org.apache.pulsar.broker.resourcegroup.ResourceGroupService;
import org.apache.pulsar.broker.resourcegroup.ResourceQuotaCalculator;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceQuotaCalculatorImpl
implements ResourceQuotaCalculator {
    private static final Logger log = LoggerFactory.getLogger(ResourceQuotaCalculatorImpl.class);

    @Override
    public long computeLocalQuota(long confUsage, long myUsage, long[] allUsages) throws PulsarAdminException {
        long totalUsage = 0L;
        for (long usage : allUsages) {
            totalUsage += usage;
        }
        if (confUsage < 0L || myUsage < 0L || totalUsage < 0L) {
            String errMesg = String.format("Configured usage (%d), or local usage (%d) or total usage (%d) is negative", confUsage, myUsage, totalUsage);
            log.error(errMesg);
            throw new PulsarAdminException(errMesg);
        }
        float residual = confUsage - totalUsage;
        float myUsageFraction = (float)myUsage / (float)totalUsage;
        float calculatedQuota = Float.max((float)myUsage + residual * myUsageFraction, 0.0f);
        return (long)calculatedQuota;
    }

    @Override
    public boolean needToReportLocalUsage(long currentBytesUsed, long lastReportedBytes, long currentMessagesUsed, long lastReportedMessages, long lastReportTimeMSecsSinceEpoch) {
        long diff;
        float diffPercentage;
        long currentTimeMSecs = System.currentTimeMillis();
        long mSecsSinceLastReport = currentTimeMSecs - lastReportTimeMSecsSinceEpoch;
        if (mSecsSinceLastReport >= ResourceGroupService.maxIntervalForSuppressingReportsMSecs) {
            return true;
        }
        float toleratedDriftPercentage = 5.0f;
        if (currentBytesUsed > 0L && (diffPercentage = (float)((diff = Math.abs(currentBytesUsed - lastReportedBytes)) / currentBytesUsed * 100L)) > 5.0f) {
            return true;
        }
        return currentMessagesUsed > 0L && (diffPercentage = (float)((diff = Math.abs(currentMessagesUsed - lastReportedMessages)) / currentMessagesUsed * 100L)) > 5.0f;
    }
}

