/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.google.common.base.Charsets;
import org.apache.pulsar.shade.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooDefs;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.shade.org.apache.zookeeper.data.Stat;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZooKeeperSessionWatcher;
import org.apache.pulsar.zookeeper.ZookeeperSessionExpiredHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalZooKeeperConnectionService
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalZooKeeperConnectionService.class);
    private final ZooKeeperClientFactory zkClientFactory;
    private final String zkConnect;
    private final long zkSessionTimeoutMillis;
    private ZooKeeper localZooKeeper;
    private ZooKeeperSessionWatcher localZooKeeperSessionWatcher;

    public LocalZooKeeperConnectionService(ZooKeeperClientFactory zkClientFactory, String zkConnect, long zkSessionTimeoutMillis) {
        this.zkClientFactory = zkClientFactory;
        this.zkConnect = zkConnect;
        this.zkSessionTimeoutMillis = zkSessionTimeoutMillis;
    }

    public void start(ZookeeperSessionExpiredHandler sessionExpiredHandler) throws IOException {
        CompletableFuture<ZooKeeper> zkFuture = this.zkClientFactory.create(this.zkConnect, ZooKeeperClientFactory.SessionType.ReadWrite, (int)this.zkSessionTimeoutMillis);
        try {
            this.localZooKeeper = zkFuture.get(this.zkSessionTimeoutMillis, TimeUnit.MILLISECONDS);
            this.localZooKeeperSessionWatcher = new ZooKeeperSessionWatcher(this.localZooKeeper, this.zkSessionTimeoutMillis, sessionExpiredHandler);
            this.localZooKeeperSessionWatcher.start();
            this.localZooKeeper.register(this.localZooKeeperSessionWatcher);
        }
        catch (Exception e) {
            throw new IOException("Failed to establish session with local ZK", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.localZooKeeperSessionWatcher != null) {
            this.localZooKeeperSessionWatcher.close();
        }
        if (this.localZooKeeper != null) {
            try {
                this.localZooKeeper.close();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    public ZooKeeper getLocalZooKeeper() {
        return this.localZooKeeper;
    }

    public static void checkAndCreatePersistNode(ZooKeeper zkc, String path) throws KeeperException, InterruptedException {
        if (zkc.exists(path, false) == null) {
            try {
                zkc.create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                LOG.info("created znode, path={}", (Object)path);
            }
            catch (Exception e) {
                LOG.warn("create znode failed, path={} : {}", new Object[]{path, e.getMessage(), e});
            }
        }
    }

    public static String createIfAbsent(ZooKeeper zk, String path, String data, CreateMode createMode) throws KeeperException, InterruptedException {
        return LocalZooKeeperConnectionService.createIfAbsent(zk, path, data, createMode, false);
    }

    public static String createIfAbsent(ZooKeeper zk, String path, String data, CreateMode createMode, boolean gc) throws KeeperException, InterruptedException {
        return LocalZooKeeperConnectionService.createIfAbsent(zk, path, data.getBytes(Charsets.UTF_8), createMode, gc);
    }

    public static String createIfAbsent(ZooKeeper zk, String path, byte[] data, CreateMode createMode) throws KeeperException, InterruptedException {
        return LocalZooKeeperConnectionService.createIfAbsent(zk, path, data, createMode, false);
    }

    public static String createIfAbsent(ZooKeeper zk, String path, byte[] data, CreateMode createMode, boolean gc) throws KeeperException, InterruptedException {
        Stat stat;
        String pathCreated = null;
        try {
            pathCreated = zk.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            LOG.debug("Create skipped for existing znode: path={}", (Object)path);
        }
        if (gc && pathCreated == null && CreateMode.EPHEMERAL.equals((Object)createMode) && (stat = zk.exists(path, false)) != null && zk.getSessionId() != stat.getEphemeralOwner()) {
            LocalZooKeeperConnectionService.deleteIfExists(zk, path, -1);
            pathCreated = zk.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
        }
        return pathCreated;
    }

    public static void deleteIfExists(ZooKeeper zk, String path, int version) throws KeeperException, InterruptedException {
        try {
            zk.delete(path, version);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            LOG.debug("Delete skipped for non-existing znode: path={}", (Object)path);
        }
    }
}

