/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.VipStatus;
import org.apache.pulsar.websocket.WebSocketConsumerServlet;
import org.apache.pulsar.websocket.WebSocketProducerServlet;
import org.apache.pulsar.websocket.WebSocketReaderServlet;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.admin.v1.WebSocketProxyStatsV1;
import org.apache.pulsar.websocket.admin.v2.WebSocketProxyStatsV2;
import org.apache.pulsar.websocket.service.ProxyServer;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServiceStarter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServiceStarter.class);

    public static void main(String[] args) throws Exception {
        Preconditions.checkArgument(args.length == 1, "Need to specify a configuration file");
        try {
            String configFile = args[0];
            log.info("Loading configuration from {}", (Object)configFile);
            WebSocketProxyConfiguration config = (WebSocketProxyConfiguration)PulsarConfigurationLoader.create(configFile, WebSocketProxyConfiguration.class);
            ProxyServer proxyServer = new ProxyServer(config);
            WebSocketService service = new WebSocketService(config);
            WebSocketServiceStarter.start(proxyServer, service);
        }
        catch (Exception e) {
            log.error("Failed to start WebSocket service", (Throwable)e);
            Runtime.getRuntime().halt(1);
        }
    }

    public static void start(ProxyServer proxyServer, WebSocketService service) throws Exception {
        proxyServer.addWebSocketServlet("/ws/producer", new WebSocketProducerServlet(service));
        proxyServer.addWebSocketServlet("/ws/consumer", new WebSocketConsumerServlet(service));
        proxyServer.addWebSocketServlet("/ws/reader", new WebSocketReaderServlet(service));
        proxyServer.addWebSocketServlet("/ws/v2/producer", new WebSocketProducerServlet(service));
        proxyServer.addWebSocketServlet("/ws/v2/consumer", new WebSocketConsumerServlet(service));
        proxyServer.addWebSocketServlet("/ws/v2/reader", new WebSocketReaderServlet(service));
        proxyServer.addRestResources("/admin", WebSocketProxyStatsV1.class.getPackage().getName(), "webProxyService", service);
        proxyServer.addRestResources("/admin/v2", WebSocketProxyStatsV2.class.getPackage().getName(), "webProxyService", service);
        proxyServer.addRestResources("/", VipStatus.class.getPackage().getName(), "statusFilePath", service.getConfig().getStatusFilePath());
        proxyServer.start();
        service.start();
    }
}

