/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;

@Beta
public interface TransactionMetadataStoreProvider {
    public static TransactionMetadataStoreProvider newProvider(String providerClassName) throws IOException {
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            Object obj = providerClass.newInstance();
            Preconditions.checkArgument(obj instanceof TransactionMetadataStoreProvider, "The factory has to be an instance of " + TransactionMetadataStoreProvider.class.getName());
            return (TransactionMetadataStoreProvider)obj;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public CompletableFuture<TransactionMetadataStore> openStore(TransactionCoordinatorID var1, ManagedLedgerFactory var2, ManagedLedgerConfig var3);
}

