/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.client;

import org.apache.pulsar.shade.javax.websocket.ClientEndpoint;
import org.apache.pulsar.shade.javax.websocket.ClientEndpointConfig;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointMetadata;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.client.AnnotatedClientEndpointConfig;

public class AnnotatedClientEndpointMetadata
extends AnnotatedEndpointMetadata<ClientEndpoint, ClientEndpointConfig> {
    private final ClientEndpoint endpoint;
    private final AnnotatedClientEndpointConfig config;

    public AnnotatedClientEndpointMetadata(ClientContainer container, Class<?> websocket) {
        super(websocket);
        ClientEndpoint anno = websocket.getAnnotation(ClientEndpoint.class);
        if (anno == null) {
            throw new InvalidWebSocketException(String.format("Unsupported WebSocket object [%s], missing @%s annotation", websocket.getName(), ClientEndpoint.class.getName()));
        }
        this.endpoint = anno;
        this.config = new AnnotatedClientEndpointConfig(anno);
        this.getDecoders().addAll(anno.decoders());
        this.getEncoders().addAll(anno.encoders());
    }

    @Override
    public ClientEndpoint getAnnotation() {
        return this.endpoint;
    }

    @Override
    public ClientEndpointConfig getConfig() {
        return this.config;
    }
}

