/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server.quorum;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.pulsar.shade.org.apache.jute.BinaryInputArchive;
import org.apache.pulsar.shade.org.apache.jute.BinaryOutputArchive;
import org.apache.pulsar.shade.org.apache.jute.CsvOutputArchive;
import org.apache.pulsar.shade.org.apache.jute.InputArchive;
import org.apache.pulsar.shade.org.apache.jute.OutputArchive;
import org.apache.pulsar.shade.org.apache.jute.Record;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class LearnerInfo
implements Record {
    private long serverid;
    private int protocolVersion;
    private long configVersion;

    public LearnerInfo() {
    }

    public LearnerInfo(long serverid, int protocolVersion, long configVersion) {
        this.serverid = serverid;
        this.protocolVersion = protocolVersion;
        this.configVersion = configVersion;
    }

    public long getServerid() {
        return this.serverid;
    }

    public void setServerid(long m_) {
        this.serverid = m_;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int m_) {
        this.protocolVersion = m_;
    }

    public long getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(long m_) {
        this.configVersion = m_;
    }

    @Override
    public void serialize(OutputArchive a_, String tag) throws IOException {
        a_.startRecord(this, tag);
        a_.writeLong(this.serverid, "serverid");
        a_.writeInt(this.protocolVersion, "protocolVersion");
        a_.writeLong(this.configVersion, "configVersion");
        a_.endRecord(this, tag);
    }

    @Override
    public void deserialize(InputArchive a_, String tag) throws IOException {
        a_.startRecord(tag);
        this.serverid = a_.readLong("serverid");
        this.protocolVersion = a_.readInt("protocolVersion");
        this.configVersion = a_.readLong("configVersion");
        a_.endRecord(tag);
    }

    public String toString() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            CsvOutputArchive a_ = new CsvOutputArchive(s);
            a_.startRecord(this, "");
            a_.writeLong(this.serverid, "serverid");
            a_.writeInt(this.protocolVersion, "protocolVersion");
            a_.writeLong(this.configVersion, "configVersion");
            a_.endRecord(this, "");
            return new String(s.toByteArray(), "UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    public void write(DataOutput out) throws IOException {
        BinaryOutputArchive archive = new BinaryOutputArchive(out);
        this.serialize(archive, "");
    }

    public void readFields(DataInput in) throws IOException {
        BinaryInputArchive archive = new BinaryInputArchive(in);
        this.deserialize(archive, "");
    }

    public int compareTo(Object peer_) throws ClassCastException {
        if (!(peer_ instanceof LearnerInfo)) {
            throw new ClassCastException("Comparing different types of records.");
        }
        LearnerInfo peer = (LearnerInfo)peer_;
        int ret = 0;
        int n = this.serverid == peer.serverid ? 0 : (ret = this.serverid < peer.serverid ? -1 : 1);
        if (ret != 0) {
            return ret;
        }
        int n2 = this.protocolVersion == peer.protocolVersion ? 0 : (ret = this.protocolVersion < peer.protocolVersion ? -1 : 1);
        if (ret != 0) {
            return ret;
        }
        int n3 = this.configVersion == peer.configVersion ? 0 : (ret = this.configVersion < peer.configVersion ? -1 : 1);
        if (ret != 0) {
            return ret;
        }
        return ret;
    }

    public boolean equals(Object peer_) {
        if (!(peer_ instanceof LearnerInfo)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        LearnerInfo peer = (LearnerInfo)peer_;
        boolean ret = false;
        boolean bl = ret = this.serverid == peer.serverid;
        if (!ret) {
            return ret;
        }
        boolean bl2 = ret = this.protocolVersion == peer.protocolVersion;
        if (!ret) {
            return ret;
        }
        boolean bl3 = ret = this.configVersion == peer.configVersion;
        if (!ret) {
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        int result = 17;
        int ret = (int)(this.serverid ^ this.serverid >>> 32);
        result = 37 * result + ret;
        ret = this.protocolVersion;
        result = 37 * result + ret;
        ret = (int)(this.configVersion ^ this.configVersion >>> 32);
        result = 37 * result + ret;
        return result;
    }

    public static String signature() {
        return "LLearnerInfo(lil)";
    }
}

