/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util.keystoretls;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextValidatorEngine {
    private static final Logger log = LoggerFactory.getLogger(SSLContextValidatorEngine.class);
    private static final ByteBuffer EMPTY_BUF = ByteBuffer.allocate(0);
    private final SSLEngine sslEngine;
    private SSLEngineResult handshakeResult;
    private ByteBuffer appBuffer;
    private ByteBuffer netBuffer;
    private Mode mode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate(SSLContext clientSslContext, SSLContext serverSslContext) throws SSLException {
        SSLContextValidatorEngine clientEngine = new SSLContextValidatorEngine(clientSslContext, Mode.CLIENT);
        SSLContextValidatorEngine serverEngine = new SSLContextValidatorEngine(serverSslContext, Mode.SERVER);
        try {
            clientEngine.beginHandshake();
            serverEngine.beginHandshake();
            while (!serverEngine.complete() || !clientEngine.complete()) {
                clientEngine.handshake(serverEngine);
                serverEngine.handshake(clientEngine);
            }
        }
        finally {
            clientEngine.close();
            serverEngine.close();
        }
    }

    private SSLContextValidatorEngine(SSLContext sslContext, Mode mode) {
        this.mode = mode;
        this.sslEngine = this.createSslEngine(sslContext, "localhost", 0);
        this.sslEngine.setUseClientMode(mode == Mode.CLIENT);
        this.appBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.netBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
    }

    private SSLEngine createSslEngine(SSLContext sslContext, String peerHost, int peerPort) {
        SSLEngine sslEngine = sslContext.createSSLEngine(peerHost, peerPort);
        if (this.mode == Mode.SERVER) {
            sslEngine.setNeedClientAuth(true);
        } else {
            sslEngine.setUseClientMode(true);
            SSLParameters sslParams = sslEngine.getSSLParameters();
            sslEngine.setSSLParameters(sslParams);
        }
        return sslEngine;
    }

    void beginHandshake() throws SSLException {
        this.sslEngine.beginHandshake();
    }

    void handshake(SSLContextValidatorEngine peerEngine) throws SSLException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
        block16: while (true) {
            switch (handshakeStatus) {
                case NEED_WRAP: {
                    this.handshakeResult = this.sslEngine.wrap(EMPTY_BUF, this.netBuffer);
                    switch (this.handshakeResult.getStatus()) {
                        case OK: {
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            this.netBuffer.compact();
                            this.netBuffer = SSLContextValidatorEngine.ensureCapacity(this.netBuffer, this.sslEngine.getSession().getPacketBufferSize());
                            this.netBuffer.flip();
                            break;
                        }
                        default: {
                            throw new SSLException("Unexpected handshake status: " + (Object)((Object)this.handshakeResult.getStatus()));
                        }
                    }
                    return;
                }
                case NEED_UNWRAP: {
                    if (peerEngine.netBuffer.position() == 0) {
                        return;
                    }
                    peerEngine.netBuffer.flip();
                    this.handshakeResult = this.sslEngine.unwrap(peerEngine.netBuffer, this.appBuffer);
                    peerEngine.netBuffer.compact();
                    handshakeStatus = this.handshakeResult.getHandshakeStatus();
                    switch (this.handshakeResult.getStatus()) {
                        case OK: {
                            continue block16;
                        }
                        case BUFFER_OVERFLOW: {
                            this.appBuffer = SSLContextValidatorEngine.ensureCapacity(this.appBuffer, this.sslEngine.getSession().getApplicationBufferSize());
                            continue block16;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.netBuffer = SSLContextValidatorEngine.ensureCapacity(this.netBuffer, this.sslEngine.getSession().getPacketBufferSize());
                            continue block16;
                        }
                    }
                    throw new SSLException("Unexpected handshake status: " + (Object)((Object)this.handshakeResult.getStatus()));
                }
                case NEED_TASK: {
                    this.sslEngine.getDelegatedTask().run();
                    handshakeStatus = this.sslEngine.getHandshakeStatus();
                    continue block16;
                }
                case FINISHED: {
                    return;
                }
                case NOT_HANDSHAKING: {
                    if (this.handshakeResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                        throw new SSLException("Did not finish handshake");
                    }
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected handshake status " + (Object)((Object)handshakeStatus));
    }

    boolean complete() {
        return this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED || this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    void close() {
        this.sslEngine.closeOutbound();
        try {
            this.sslEngine.closeInbound();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ByteBuffer ensureCapacity(ByteBuffer existingBuffer, int newLength) {
        if (newLength > existingBuffer.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocate(newLength);
            existingBuffer.flip();
            newBuffer.put(existingBuffer);
            return newBuffer;
        }
        return existingBuffer;
    }

    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

