/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.stats;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.JvmGCMetricsLogger;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.management.HotspotRuntimeMBean;
import sun.management.ManagementFactoryHelper;

public class JvmDefaultGCMetricsLogger
implements JvmGCMetricsLogger {
    private static final Logger log = LoggerFactory.getLogger(JvmDefaultGCMetricsLogger.class);
    private volatile long accumulatedFullGcCount = 0L;
    private volatile long currentFullGcCount = 0L;
    private volatile long accumulatedFullGcTime = 0L;
    private volatile long currentFullGcTime = 0L;
    private static HotspotRuntimeMBean runtime;
    private Map<String, GCMetrics> gcMetricsMap = Maps.newHashMap();

    @Override
    public void logMetrics(Metrics metrics) {
        metrics.put("jvm_full_gc_pause", this.currentFullGcTime);
        metrics.put("jvm_full_gc_count", this.currentFullGcCount);
        this.gcMetricsMap.forEach((name, metric) -> {
            metrics.put("jvm_" + name + "_gc_pause", metric.currentGcTime);
            metrics.put("jvm_" + name + "_gc_count", metric.currentGcCount);
        });
    }

    @Override
    public void refresh() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        try {
            if (gcBeans != null) {
                for (GarbageCollectorMXBean gc : gcBeans) {
                    GCMetrics gcMetric = this.gcMetricsMap.computeIfAbsent(gc.getName(), gcName -> new GCMetrics());
                    long newGcTime = gc.getCollectionTime();
                    long newGcCount = gc.getCollectionCount();
                    gcMetric.currentGcCount = newGcCount - gcMetric.accumulatedGcCount;
                    gcMetric.currentGcTime = newGcTime - gcMetric.accumulatedGcTime;
                    gcMetric.accumulatedGcCount = newGcCount;
                    gcMetric.accumulatedGcTime = newGcTime;
                }
            }
            long newSafePointTime = runtime.getTotalSafepointTime();
            long newSafePointCount = runtime.getSafepointCount();
            this.currentFullGcTime = newSafePointTime - this.accumulatedFullGcTime;
            this.currentFullGcCount = newSafePointCount - this.accumulatedFullGcCount;
            this.accumulatedFullGcTime = newSafePointTime;
            this.accumulatedFullGcCount = newSafePointCount;
        }
        catch (Exception e) {
            log.error("Failed to collect GC stats: {}", (Object)e.getMessage());
        }
    }

    static {
        try {
            runtime = ManagementFactoryHelper.getHotspotRuntimeMBean();
        }
        catch (Exception e) {
            log.warn("Failed to get Runtime bean", (Throwable)e);
        }
    }

    static class GCMetrics {
        volatile long accumulatedGcCount = 0L;
        volatile long currentGcCount = 0L;
        volatile long accumulatedGcTime = 0L;
        volatile long currentGcTime = 0L;

        GCMetrics() {
        }
    }
}

