/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.policies.data;

import java.util.List;
import java.util.Map;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NonPersistentPublisherStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NonPersistentReplicatorStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NonPersistentSubscriptionStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicStats;

public class NonPersistentTopicStats
extends TopicStats {
    public double msgDropRate;
    public List<NonPersistentPublisherStats> publishers = Lists.newArrayList();
    public Map<String, NonPersistentSubscriptionStats> subscriptions = Maps.newHashMap();
    public Map<String, NonPersistentReplicatorStats> replication = Maps.newTreeMap();

    @Override
    public void reset() {
        super.reset();
        this.msgDropRate = 0.0;
    }

    public NonPersistentTopicStats add(NonPersistentTopicStats stats) {
        Preconditions.checkNotNull(stats);
        super.add(stats);
        this.msgDropRate += stats.msgDropRate;
        return this;
    }

    public List<NonPersistentPublisherStats> getPublishers() {
        return this.publishers;
    }

    public Map<String, NonPersistentSubscriptionStats> getSubscriptions() {
        return this.subscriptions;
    }

    public Map<String, NonPersistentReplicatorStats> getReplication() {
        return this.replication;
    }
}

